/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface IInputParser {
    default public int parseInt(String input) {
        String pattern = "-?\\d+";
        Matcher matcher = Pattern.compile(pattern).matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString().isEmpty() ? 0 : this.toValidStringAndGetInt(sb.toString());
    }

    default public float parseFloat(String input) {
        String pattern = "-?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?";
        Matcher matcher = Pattern.compile(pattern).matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString().isEmpty() ? 0.0f : Float.parseFloat(sb.toString());
    }

    default public double parseDouble(String input) {
        String pattern = "-?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?";
        Matcher matcher = Pattern.compile(pattern).matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString().isEmpty() ? 0.0 : Double.parseDouble(sb.toString());
    }

    default public long parseLong(String input) {
        String pattern = "-?\\d+";
        Matcher matcher = Pattern.compile(pattern).matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString().isEmpty() ? 0L : Long.parseLong(sb.toString());
    }

    default public boolean parseBoolean(String input) {
        String pattern = "(?i)(?:true|false)|^(?!0(?:\\.0+)?$)(?:[1-9]\\d*|0)(?:\\.\\d+)?";
        Matcher matcher = Pattern.compile(pattern).matcher(input);
        StringBuilder sb = new StringBuilder();
        if (matcher.find()) {
            sb.append(matcher.group());
            return Boolean.parseBoolean(sb.toString());
        }
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return !sb.toString().isEmpty() && Boolean.parseBoolean(sb.toString());
    }

    default public int toValidStringAndGetInt(String input) {
        String pattern = "-?\\d+";
        String substring = input.substring(0, Math.min(input.length(), 9));
        Matcher matcher = Pattern.compile(pattern).matcher(substring);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group());
        }
        return 0;
    }

    default public int hasPosOrNegSymbol(String parsedStr) {
        if (parsedStr.contains("+") || parsedStr.contains("-")) {
            return 1;
        }
        return 0;
    }
}

