/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.client.layout;

import github.thelawf.gensokyoontology.client.gui.screen.widget.BlankWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class WidgetConfig {
    public int width;
    public int height;
    public int u;
    public int v;
    public int upInterval;
    public int downInterval;
    public int leftInterval;
    public int rightInterval;
    public Widget widget;
    public ResourceLocation texture = new ResourceLocation("");
    public FontRenderer fontRenderer;
    public ITextComponent text;
    public Button.IPressable action;
    public boolean isText;
    public static final WidgetConfig DEFAULT = new WidgetConfig(BlankWidget.INSTANCE, 0, 0);
    public static final WidgetConfig TEXT = new WidgetConfig(BlankWidget.INSTANCE, 0, 0).isText(true);

    public WidgetConfig(Widget widget, int width, int height) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.text = new StringTextComponent("");
        this.widget = widget;
        this.width = width;
        this.height = height;
    }

    public static WidgetConfig of(Widget widget, int width, int height) {
        return new WidgetConfig(widget, width, height);
    }

    public static WidgetConfig of(Widget widget) {
        return new WidgetConfig(widget, widget.func_230998_h_(), widget.func_238483_d_());
    }

    public WidgetConfig withFont(FontRenderer rendererIn) {
        this.fontRenderer = rendererIn;
        return this;
    }

    public WidgetConfig withAction(Button.IPressable actionIn) {
        this.action = actionIn;
        return this;
    }

    public WidgetConfig withText(ITextComponent titleIn) {
        this.text = titleIn;
        return this;
    }

    public WidgetConfig upInterval(int upIntervalIn) {
        this.upInterval = upIntervalIn;
        return this;
    }

    public WidgetConfig downInterval(int downIntervalIn) {
        this.downInterval = downIntervalIn;
        return this;
    }

    public WidgetConfig leftInterval(int leftInterval) {
        this.leftInterval = leftInterval;
        return this;
    }

    public WidgetConfig upLeft(int upInterval, int leftInterval) {
        this.upInterval = upInterval;
        this.leftInterval = leftInterval;
        return this;
    }

    public WidgetConfig setXY(int x, int y) {
        this.leftInterval = x;
        this.upInterval = y;
        return this;
    }

    public WidgetConfig rightInterval(int rightIntervalIn) {
        this.rightInterval = rightIntervalIn;
        return this;
    }

    public WidgetConfig setUV(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public WidgetConfig texture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public WidgetConfig isText(boolean isText) {
        this.isText = isText;
        return this;
    }

    public static enum Type {
        BUTTON,
        INTERVAL,
        TEXT_FIELD,
        LABEL;

    }
}

