/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.client.xmmui;

import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;

public interface IXMLValueParser {
    default public List<String> separateBySemicolon(String value) {
        return Arrays.asList(value.split(";"));
    }

    default public List<String> separateByComma(String value) {
        return Arrays.asList(value.split(","));
    }

    default public List<String> separateByBlank(String value) {
        return Arrays.asList(value.split(" "));
    }

    default public List<String> separateByColon(String value) {
        return Arrays.asList(value.split(":"));
    }

    default public boolean getBoolValue(String value) {
        return Boolean.parseBoolean(value.split("=")[1]);
    }

    default public <T extends Enum<T>> T getEnumValue(String value, Class<T> enumClass) {
        return Enum.valueOf(enumClass, value);
    }

    default public <T extends Enum<T>> T getEnumOrDefault(String value, Class<T> enumClass, T defaultValue) {
        return Enum.valueOf(enumClass, value);
    }

    default public int getIntValue(String value) {
        return Integer.parseInt(value);
    }

    default public int parseRGBAColor(String hexColor) {
        return hexColor.contains("#") ? Integer.parseInt(hexColor.substring(1, hexColor.length() - 1)) : 0;
    }

    default public float parsePercent(String percent) {
        return percent.contains("%") ? Float.parseFloat(percent.substring(percent.length() - 2, percent.length() - 1)) / 100.0f : 0.0f;
    }

    default public String getOrDefault(Element element, String key, String defaultValue) {
        return element.attributeValue(key) == null ? defaultValue : element.attributeValue(key);
    }
}

