/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.util;

import github.thelawf.gensokyoontology.api.util.INBTReader;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public interface INBTWriter
extends INBTReader {
    default public void writeBoolean(ItemStack stack, String key, Boolean value) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a(key, value.booleanValue());
        stack.func_77982_d(nbt);
    }

    default public void writeString(ItemStack stack, String key, String value) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(key, value);
        stack.func_77982_d(nbt);
    }

    default public void writeBlockPos(ItemStack stack, String key, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a(key, pos.func_218275_a());
        stack.func_77982_d(nbt);
    }

    default public void mergeBoolean(ItemStack stack, String key, Boolean value) {
        CompoundNBT nbt = this.getOrCreateTag(stack);
        CompoundNBT newNBT = new CompoundNBT();
        newNBT.func_74757_a(key, value.booleanValue());
        nbt.func_197643_a(newNBT);
        stack.func_77982_d(nbt);
    }

    default public void mergeString(ItemStack stack, String key, String value) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(key, value);
        stack.func_77982_d(nbt);
    }

    default public void mergeBlockPos(ItemStack stack, String key, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a(key, pos.func_218275_a());
        stack.func_77982_d(nbt);
    }

    default public CompoundNBT withBlockPos(CompoundNBT nbt, String xKey, String yKey, String zKey, BlockPos pos) {
        nbt.func_74768_a(xKey, pos.func_177958_n());
        nbt.func_74768_a(yKey, pos.func_177956_o());
        nbt.func_74768_a(zKey, pos.func_177952_p());
        return nbt;
    }

    default public void mergeBlockPos(ItemStack stack, String xKey, String yKey, String zKey, BlockPos pos) {
        CompoundNBT nbt = this.getOrCreateTag(stack);
        CompoundNBT newNBT = new CompoundNBT();
        newNBT.func_74768_a(xKey, pos.func_177958_n());
        newNBT.func_74768_a(yKey, pos.func_177956_o());
        newNBT.func_74768_a(zKey, pos.func_177952_p());
        nbt.func_197643_a(newNBT);
        stack.func_77982_d(nbt);
    }

    default public void writeStringIf(Predicate<ItemStack> predicate, ItemStack stack, String key, String value) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74778_a(key, value);
            stack.func_77982_d(nbt);
        }
    }

    default public void writeBooleanIf(Predicate<ItemStack> predicate, ItemStack stack, String key, boolean value) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74757_a(key, value);
            stack.func_77982_d(nbt);
        }
    }

    default public void writeBlockPosIf(Predicate<ItemStack> predicate, ItemStack stack, String key, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74772_a(key, pos.func_218275_a());
            stack.func_77982_d(nbt);
        }
    }

    default public void mergeStringIf(Predicate<ItemStack> predicate, ItemStack stack, String key, String value) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74778_a(key, value);
            stack.func_77982_d(nbt);
        }
    }

    default public void mergeBooleanIf(Predicate<ItemStack> predicate, ItemStack stack, String key, boolean value) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74757_a(key, value);
            stack.func_77982_d(nbt);
        }
    }

    default public void mergeBlockPosIf(Predicate<ItemStack> predicate, ItemStack stack, String key, BlockPos pos) {
        CompoundNBT nbt = new CompoundNBT();
        if (predicate.test(stack)) {
            nbt.func_74772_a(key, pos.func_218275_a());
            stack.func_77982_d(nbt);
        }
    }
}

