/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.util;

import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public interface IRayTraceReader {
    default public List<List<AxisAlignedBB>> getRayTraceBox(Vector3d globalPos, Vector3d rayDirection, int length, float size) {
        ArrayList<List<AxisAlignedBB>> boxes = new ArrayList<List<AxisAlignedBB>>();
        ArrayList<AxisAlignedBB> aabb = new ArrayList<AxisAlignedBB>();
        for (int i = 0; i < 50; ++i) {
            Vector3d posRow = new Vector3d(rayDirection.field_72450_a > 0.0 ? Vector3f.field_229179_b_ : Vector3f.field_229178_a_);
            Vector3d posColumn = new Vector3d(rayDirection.field_72449_c > 0.0 ? Vector3f.field_229183_f_ : Vector3f.field_229182_e_);
            Vector3d posVertical = new Vector3d(rayDirection.field_72448_b > 0.0 ? Vector3f.field_229181_d_ : Vector3f.field_229180_c_);
            Vector3d rayPos = globalPos.func_178787_e(rayDirection);
            AxisAlignedBB aabb0 = new AxisAlignedBB(GSKOMathUtil.vecFloor(rayPos), GSKOMathUtil.vecCeil(rayPos));
            AxisAlignedBB aabb1 = new AxisAlignedBB(GSKOMathUtil.vecFloor(rayPos.func_178787_e(posRow)), GSKOMathUtil.vecCeil(rayPos.func_178787_e(posRow)));
            AxisAlignedBB aabb2 = new AxisAlignedBB(GSKOMathUtil.vecFloor(rayPos.func_178787_e(posColumn)), GSKOMathUtil.vecCeil(rayPos.func_178787_e(posColumn)));
            AxisAlignedBB aabb3 = new AxisAlignedBB(GSKOMathUtil.vecFloor(rayPos.func_178787_e(posVertical)), GSKOMathUtil.vecCeil(rayPos.func_178787_e(posVertical)));
            aabb.add(aabb0.func_186662_g((double)size));
            aabb.add(aabb1.func_186662_g((double)size));
            aabb.add(aabb2.func_186662_g((double)size));
            aabb.add(aabb3.func_186662_g((double)size));
            boxes.add(aabb);
        }
        return boxes;
    }

    default public AxisAlignedBB createCubeBox(Vector3d pos, int radius) {
        return new AxisAlignedBB(pos.func_178788_d(new Vector3d((double)radius, (double)radius, (double)radius)), pos.func_178787_e(new Vector3d((double)radius, (double)radius, (double)radius)));
    }

    default public <T extends Entity> List<T> getEntityWithin(World worldIn, Class<? extends T> entityClass, AxisAlignedBB aabb, @Nullable Predicate<? super T> predicate) {
        if (predicate != null) {
            return worldIn.func_217357_a(entityClass, aabb).stream().filter(predicate).collect(Collectors.toList());
        }
        return worldIn.func_217357_a(entityClass, aabb);
    }

    default public boolean isIntersecting(Vector3d start, Vector3d end, Vector3d boxMin, Vector3d boxMax) {
        double tzMax;
        double tzMin;
        double tyMax;
        double tyMin;
        double tMin = (boxMin.field_72450_a - start.field_72450_a) / (end.field_72450_a - start.field_72450_a);
        double tMax = (boxMax.field_72450_a - start.field_72450_a) / (end.field_72450_a - start.field_72450_a);
        if (tMin > tMax) {
            double temp = tMin;
            tMin = tMax;
            tMax = temp;
        }
        if ((tyMin = (boxMin.field_72448_b - start.field_72448_b) / (end.field_72448_b - start.field_72448_b)) > (tyMax = (boxMax.field_72448_b - start.field_72448_b) / (end.field_72448_b - start.field_72448_b))) {
            double temp = tyMin;
            tyMin = tyMax;
            tyMax = temp;
        }
        if (tMin > tyMax || tyMin > tMax) {
            return false;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        if ((tzMin = (boxMin.field_72449_c - start.field_72449_c) / (end.field_72449_c - start.field_72449_c)) > (tzMax = (boxMax.field_72449_c - start.field_72449_c) / (end.field_72449_c - start.field_72449_c))) {
            double temp = tzMin;
            tzMin = tzMax;
            tzMax = temp;
        }
        return !(tMin > tzMax) && !(tzMin > tMax);
    }

    default public boolean isIntersecting(Vector3d start, Vector3d end, AxisAlignedBB aabb) {
        return this.isIntersecting(start, end, new Vector3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vector3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
    }

    default public boolean isIntersecting(Vector3d start, Vector3d direction, double distance, AxisAlignedBB aabb) {
        return this.isIntersecting(start, start.func_178787_e(direction).func_186678_a(distance), new Vector3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vector3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
    }

    @Nullable
    default public EntityRayTraceResult rayTrace(World worldIn, Entity entityIn, Vector3d start, Vector3d end, AxisAlignedBB boundingBox, Predicate<Entity> selector, double limitDist) {
        double currentDist = limitDist;
        Entity resultEntity = null;
        for (Entity foundEntity : worldIn.func_175674_a(entityIn, boundingBox, selector)) {
            double newDist;
            AxisAlignedBB axisalignedbb = foundEntity.func_174813_aQ().func_186662_g(0.5);
            Optional optional = axisalignedbb.func_216365_b(start, end);
            if (!optional.isPresent() || !((newDist = start.func_72436_e((Vector3d)optional.get())) < currentDist)) continue;
            resultEntity = foundEntity;
            currentDist = newDist;
        }
        if (resultEntity == null) {
            return null;
        }
        return new EntityRayTraceResult(resultEntity);
    }

    default public Optional<Entity> rayTrace(World world, Entity sourceEntity, Vector3d startVec, Vector3d endVec) {
        double closestDistance = startVec.func_72438_d(endVec);
        for (Entity entity : world.func_217357_a(Entity.class, sourceEntity.func_174813_aQ().func_186662_g(startVec.func_72438_d(endVec)))) {
            double distance;
            AxisAlignedBB entityAABB;
            Optional result;
            if (entity == sourceEntity || !(result = (entityAABB = entity.func_174813_aQ()).func_216365_b(startVec, endVec)).isPresent() || !((distance = startVec.func_72436_e((Vector3d)result.get())) < closestDistance)) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    default public Vector3d getIntersectedPos(Vector3d start, Vector3d end, AxisAlignedBB aabb) {
        return this.getIntersectedPos(start, end, new Vector3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vector3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
    }

    default public Vector3d getIntersectedPos(Vector3d start, Vector3d end, Vector3d boxMin, Vector3d boxMax) {
        double tzMax;
        double tzMin;
        double tyMax;
        double tyMin;
        double tMin = (boxMin.field_72450_a - start.field_72450_a) / (end.field_72450_a - start.field_72450_a);
        double tMax = (boxMax.field_72450_a - start.field_72450_a) / (end.field_72450_a - start.field_72450_a);
        if (tMin > tMax) {
            double temp = tMin;
            tMin = tMax;
            tMax = temp;
        }
        if ((tyMin = (boxMin.field_72448_b - start.field_72448_b) / (end.field_72448_b - start.field_72448_b)) > (tyMax = (boxMax.field_72448_b - start.field_72448_b) / (end.field_72448_b - start.field_72448_b))) {
            double temp = tyMin;
            tyMin = tyMax;
            tyMax = temp;
        }
        if (tMin > tyMax || tyMin > tMax) {
            return Vector3d.field_186680_a;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        if ((tzMin = (boxMin.field_72449_c - start.field_72449_c) / (end.field_72449_c - start.field_72449_c)) > (tzMax = (boxMax.field_72449_c - start.field_72449_c) / (end.field_72449_c - start.field_72449_c))) {
            double temp = tzMin;
            tzMin = tzMax;
            tzMax = temp;
        }
        if (tMin > tzMax || tzMin > tMax) {
            return Vector3d.field_186680_a;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        return new Vector3d(start.field_72450_a + tMin * (end.field_72450_a - start.field_72450_a), start.field_72448_b + tMin * (end.field_72448_b - start.field_72448_b), start.field_72449_c + tMin * (end.field_72449_c - start.field_72449_c));
    }

    default public <T extends Entity> List<T> getEntityWithinSphere(World worldIn, Class<? extends T> entityClass, AxisAlignedBB aabb, float radius) {
        return worldIn.func_217357_a(entityClass, aabb).stream().filter(t -> aabb.func_189972_c().func_72438_d(t.func_213303_ch()) <= (double)radius).collect(Collectors.toList());
    }

    default public Vector3d getLookEnd(Vector3d startPos, Vector3d lookVec, double eyeHeight, double distance) {
        return lookVec.func_186678_a(distance).func_178787_e(startPos.func_72441_c(0.0, eyeHeight, 0.0));
    }

    default public Vector3d getAimedVec(LivingEntity source, Entity target) {
        return target.func_213303_ch().func_178788_d(source.func_213303_ch());
    }

    default public <T extends Entity> List<T> getEntityWithinSphere(World worldIn, Class<? extends T> entityClass, Predicate<? super T> predicate, AxisAlignedBB aabb, float radius) {
        return worldIn.func_217357_a(entityClass, aabb).stream().filter(t -> aabb.func_189972_c().func_72438_d(t.func_213303_ch()) <= (double)radius && predicate.test(t)).collect(Collectors.toList());
    }
}

