/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.api.util.tree;

import github.thelawf.gensokyoontology.api.util.tree.ITreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public abstract class TreeNode<O>
implements ITreeNode<O> {
    public O object;
    public String name;
    public int id;
    public boolean isRoot;
    public TreeNode<O> parent;
    public List<TreeNode<O>> ancestors = new ArrayList<TreeNode<O>>();
    public List<TreeNode<O>> children = new ArrayList<TreeNode<O>>();
    public final HashMap<String, TreeNode<O>> treeMap = new HashMap();
    public final HashMap<Integer, TreeNode<O>> indexingMap = new HashMap();

    @Override
    public O get() {
        return this.object;
    }

    public TreeNode(String name) {
        this.name = name;
        this.isRoot = true;
    }

    @Override
    public void addChild(TreeNode<O> child) {
        if (this.contains(child.name)) {
            throw new IllegalArgumentException("The Name of the Child Node already exists.");
        }
        child.parent = this;
        this.children.add(child);
        if (this.isRoot) {
            this.treeMap.put(this.name, this);
            this.indexingMap.put(this.id, this);
        }
        child.id = this.id++;
    }

    @Override
    public boolean contains(String nameIn) {
        boolean b1 = Objects.equals(this.name, nameIn);
        boolean b2 = false;
        boolean b3 = false;
        if (!b1 && this.ancestors.size() == 0 && this.children.size() == 0) {
            return false;
        }
        if (this.ancestors.size() != 0) {
            for (TreeNode<O> node : this.ancestors) {
                if (!node.contains(nameIn)) continue;
                b2 = true;
                break;
            }
        }
        for (TreeNode<O> node : this.children) {
            if (!node.contains(nameIn)) continue;
            b3 = true;
            break;
        }
        return b1 || b2 || b3;
    }

    @Override
    public boolean hasName(String nameIn) {
        return this.name.equals(nameIn);
    }

    @Override
    public TreeNode<O> getNode(String nameIn) {
        if (this.ancestors.size() != 0) {
            for (TreeNode<O> node : this.ancestors) {
                if (!node.contains(nameIn)) continue;
                return node;
            }
        }
        for (TreeNode<O> node : this.children) {
            if (!node.contains(nameIn)) continue;
            return node;
        }
        return null;
    }

    public void sort(SortType sortType) {
        switch (sortType) {
            default: 
        }
    }

    @Override
    public boolean hasChild() {
        return this.children.size() > 0;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean hasAncestors() {
        return this.ancestors.size() > 0;
    }

    static enum SortType {
        DEPTH_FIRST,
        WIDTH_FIRST;

    }
}

