/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.client.gui.screen.script.ScriptContainerScreen;
import github.thelawf.gensokyoontology.common.container.SpellCardConsoleContainer;
import github.thelawf.gensokyoontology.common.network.GSKONetworking;
import github.thelawf.gensokyoontology.common.network.packet.CAddScriptPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.jetbrains.annotations.NotNull;

public class SpellCardConsoleScreen
extends ScriptContainerScreen<SpellCardConsoleContainer> {
    public static final ITextComponent SAVE_TIP = GensokyoOntology.withTranslation("tooltip.", ".spell_console.button.save");
    public static final ITextComponent COPY_TIP = GensokyoOntology.withTranslation("tooltip.", ".spell_console.button.copy");
    public static final ITextComponent SAVED_MSG = GensokyoOntology.withTranslation("msg.", ".spell_console.button.saved");
    public static final ITextComponent COPIED_MSG = GensokyoOntology.withTranslation("msg.", ".spell_console.button.copied");
    public static final ResourceLocation BUTTONS_TEX = GensokyoOntology.withRL("textures/gui/widget/buttons.png");
    public static final ResourceLocation SCREEN_TEXTURE = GensokyoOntology.withRL("textures/gui/spell_card_console.png");
    private final CompoundNBT scriptData = new CompoundNBT();

    public SpellCardConsoleScreen(SpellCardConsoleContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        Minecraft mc = Minecraft.func_71410_x();
        this.field_238742_p_ = 6;
        this.field_238743_q_ = 6;
        this.field_146999_f = 247;
        this.field_147000_g = 249;
        this.field_238744_r_ = 46;
        this.field_238745_s_ = 158;
    }

    private void addTooltip(Button button, MatrixStack matrixStack, ITextComponent text, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        int sw = this.field_230706_i_.func_228018_at_().func_198099_q();
        int sh = this.field_230706_i_.func_228018_at_().func_198079_r();
        GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)Lists.newArrayList((Object[])new ITextComponent[]{text}), (int)mouseX, (int)mouseY, (int)sw, (int)sh, (int)300, (FontRenderer)this.field_230712_o_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void saveButtonAction(Button button) {
        if (this.field_230706_i_ == null) {
            return;
        }
        if (this.field_230706_i_.field_71439_g == null) {
            return;
        }
        GSKONetworking.CHANNEL.sendToServer((Object)new CAddScriptPacket());
        this.field_230706_i_.field_71439_g.func_145747_a(SAVED_MSG, this.field_230706_i_.field_71439_g.func_110124_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void copyButtonAction(Button button) {
        if (this.field_230706_i_ == null) {
            return;
        }
        if (this.field_230706_i_.field_71439_g == null) {
            return;
        }
        if (!(this.field_230706_i_.field_71439_g.field_71070_bA instanceof SpellCardConsoleContainer)) {
            return;
        }
        SpellCardConsoleContainer container = (SpellCardConsoleContainer)this.field_230706_i_.field_71439_g.field_71070_bA;
        if (container.getOutputStack().func_77978_p() == null) {
            return;
        }
        INBT inbt = container.getOutputStack().func_77978_p().func_74781_a("scripts");
        if (inbt == null) {
            return;
        }
        this.scriptData.func_218657_a("scripts", inbt);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        this.toJson(builder, this.scriptData);
        builder.append("}");
        this.field_230706_i_.field_195559_v.func_197960_a(builder.toString());
        this.field_230706_i_.field_71439_g.func_145747_a(COPIED_MSG, this.field_230706_i_.field_71439_g.func_110124_au());
    }

    private void toJson(StringBuilder sb, CompoundNBT compound) {
        for (String key : compound.func_150296_c()) {
            INBT inbt;
            if (this.field_230706_i_ == null || this.field_230706_i_.field_71439_g == null) {
                return;
            }
            if (!compound.func_74764_b(key) || (inbt = compound.func_74781_a(key)) == null) continue;
            if (inbt instanceof CompoundNBT) {
                CompoundNBT nbt = (CompoundNBT)inbt;
                sb.append("\"").append(key).append("\"").append(":{");
                this.toJson(sb, nbt);
            }
            if (inbt instanceof ListNBT) {
                ListNBT listNBT = (ListNBT)inbt;
                ArrayList compoundList = new ArrayList();
                ArrayList numberArr = new ArrayList();
                ArrayList stringArr = new ArrayList();
                listNBT.forEach(element -> {
                    if (element instanceof CompoundNBT) {
                        CompoundNBT nbt = (CompoundNBT)element;
                        compoundList.add(nbt);
                    }
                    if (element instanceof NumberNBT) {
                        NumberNBT numberNBT = (NumberNBT)element;
                        numberArr.add(numberNBT.func_209908_j());
                    }
                    if (element instanceof StringNBT) {
                        StringNBT stringNBT = (StringNBT)element;
                        stringArr.add(stringNBT.toString());
                    }
                });
                if (compoundList.size() != 0) {
                    sb.append("\"").append(key).append("\":[");
                    for (CompoundNBT nbt : compoundList) {
                        sb.append("{");
                        this.toJson(sb, nbt);
                        if (compoundList.indexOf(nbt) >= compoundList.size() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    this.appendCommaOrBracket(sb, compound, key);
                }
                if (numberArr.size() != 0) {
                    sb.append("\"").append(key).append("\":").append(numberArr);
                }
                if (stringArr.size() != 0) {
                    sb.append("\"").append(key).append("\":").append(stringArr);
                }
            }
            if (inbt instanceof NumberNBT) {
                NumberNBT numberNBT = (NumberNBT)inbt;
                sb.append("\"").append(key).append("\":").append(numberNBT.func_209908_j());
                this.appendCommaOrBracket(sb, compound, key);
            }
            if (!(inbt instanceof StringNBT)) continue;
            StringNBT stringNBT = (StringNBT)inbt;
            sb.append("\"").append(key).append("\":").append(stringNBT);
            this.appendCommaOrBracket(sb, compound, key);
        }
    }

    private void appendCommaOrBracket(StringBuilder sb, CompoundNBT compound, String key) {
        if (new ArrayList(compound.func_150296_c()).indexOf(key) < new ArrayList(compound.func_150296_c()).size() - 1) {
            sb.append(",");
        } else {
            sb.append("}");
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 10, 167, 28, 28, 0, 0, 0, BUTTONS_TEX, 256, 256, this::saveButtonAction, (a, b, c, d) -> {}, this.withText("")){

            public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                if (this.field_230692_n_) {
                    this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 28, 0, this.field_230688_j_, this.field_230689_k_);
                    SpellCardConsoleScreen.this.addTooltip((Button)this, matrixStack, SAVE_TIP, mouseX, mouseY);
                }
            }
        });
        this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 10, 204, 28, 28, 0, 28, 0, BUTTONS_TEX, 256, 256, this::copyButtonAction, (a, b, c, d) -> {}, this.withText("")){

            public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                if (this.field_230692_n_) {
                    this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 28, 28, this.field_230688_j_, this.field_230689_k_);
                    SpellCardConsoleScreen.this.addTooltip((Button)this, matrixStack, COPY_TIP, mouseX, mouseY);
                }
            }
        });
    }

    @Override
    public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230450_a_(@NotNull MatrixStack matrixStack, float partialTicks, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(SCREEN_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, 247, 249);
    }

    private Button createOperationOptionBtn(int x, int y, ITextComponent title) {
        return new Button(x, y, 60, 20, title, button -> {});
    }

    private Button createInstanceOptionBtn(int x, int y, ITextComponent title) {
        return new Button(x, y, 80, 20, title, button -> {});
    }
}

