/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.gui.screen.script;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.client.layout.WidgetConfig;
import github.thelawf.gensokyoontology.client.gui.screen.script.OneSlotContainerScreen;
import github.thelawf.gensokyoontology.client.gui.screen.widget.BlankWidget;
import github.thelawf.gensokyoontology.common.container.script.OneSlotContainer;
import github.thelawf.gensokyoontology.common.nbt.GSKONBTUtil;
import github.thelawf.gensokyoontology.common.nbt.script.ConstPreset;
import github.thelawf.gensokyoontology.common.nbt.script.ConstType;
import github.thelawf.gensokyoontology.common.network.GSKONetworking;
import github.thelawf.gensokyoontology.common.network.packet.CMergeScriptPacket;
import github.thelawf.gensokyoontology.common.util.EnumUtil;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ConstBuilderScreen
extends OneSlotContainerScreen {
    private Button constTypeBtn;
    private Button presetBtn;
    private ConstPreset constPreset;
    private ConstType constType;
    private TextFieldWidget nameInput;
    private TextFieldWidget valueInput;
    private final CompoundNBT constData = new CompoundNBT();
    public static final ResourceLocation TEXTURE = GensokyoOntology.withRL("textures/gui/one_slot_screen_const.png");
    private final WidgetConfig NAME_LABEL = WidgetConfig.of(new BlankWidget(0, 0, 0, 0, this.withText("null")), 0, 0).isText(true);
    private final WidgetConfig VALUE_LABEL = WidgetConfig.of(new BlankWidget(0, 0, 0, 0, this.withText("null")), 0, 0).isText(true);
    private final ITextComponent defaultName = GensokyoOntology.withTranslation("gui.", ".default.set_name");
    private final ITextComponent defaultValue = GensokyoOntology.withTranslation("gui.", ".default.set_value");
    private final ITextComponent presetDefault = GensokyoOntology.withTranslation("gui.", ".const_builder.button.preset.none");
    private final ITextComponent intTypeText = GensokyoOntology.withTranslation("gui.", ".const_builder.button.constType.int");
    private final ITextComponent valueText = GensokyoOntology.withTranslation("gui.", ".const_builder.tip.valueInput");
    public List<WidgetConfig> WIDGETS;

    public ConstBuilderScreen(OneSlotContainer container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(container, playerInventory, titleIn);
        this.field_238742_p_ = 6;
        this.field_238743_q_ = 6;
        this.field_238744_r_ = 30;
        this.field_238745_s_ = 114;
        this.field_146999_f = 223;
        this.field_147000_g = 223;
        this.constPreset = ConstPreset.NONE;
        this.constType = ConstType.INT;
        this.stack = playerInventory.field_70458_d.func_184614_ca();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.nameInput.func_146178_a();
        this.valueInput.func_146178_a();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.field_230706_i_ == null) {
            return;
        }
        if (this.field_230706_i_.field_71439_g == null) {
            return;
        }
        if (this.constPreset == ConstPreset.NONE) {
            this.constTypeBtn = new Button(200, 60, 20, 20, this.intTypeText, button -> {
                this.constType = EnumUtil.switchEnum(ConstType.class, this.constType);
            });
        }
        this.presetBtn = new Button(0, 0, 100, 20, this.presetDefault, button -> {
            this.insertNameAndValue();
            this.constPreset = EnumUtil.switchEnum(ConstPreset.class, this.constPreset);
            this.field_230705_e_.remove(this.constTypeBtn);
        });
        this.nameInput = new TextFieldWidget(this.field_230706_i_.field_71466_p, 30, 30, 100, 20, this.defaultName);
        this.valueInput = new TextFieldWidget(this.field_230706_i_.field_71466_p, 160, 30, 100, 20, this.defaultValue);
        this.saveBtn = new Button(0, 200, 20, 20, this.saveText, this::saveBtnAction);
        this.WIDGETS = Lists.newArrayList((Object[])new WidgetConfig[]{this.NAME_LABEL.setXY(10, 62).withFont(this.field_230712_o_).withText(this.fieldName), this.VALUE_LABEL.setXY(10, 92).withFont(this.field_230712_o_).withText(this.valueText), WidgetConfig.of((Widget)this.nameInput, 100, 20).setXY(40, 60).withFont(this.field_230712_o_).withText(this.constPreset.toTextComponent()), WidgetConfig.of((Widget)this.valueInput, 100, 20).setXY(40, 90).withFont(this.field_230712_o_).withText(this.constPreset.toTextComponent()), WidgetConfig.of((Widget)this.presetBtn, 90, 20).setXY(25, 25).withFont(this.field_230712_o_).withText(this.constPreset.toTextComponent()).withAction(this::presetBtnAction), WidgetConfig.of((Widget)this.constTypeBtn, 90, 20).setXY(115, 25).withFont(this.field_230712_o_).withText(this.constType.toTextComponent()).withAction(this::constTypeBtnAction), WidgetConfig.of((Widget)this.saveBtn, 60, 20).setXY(150, 90).withFont(this.field_230712_o_).withText(this.saveText).withAction(this::saveBtnAction)});
        this.setRelativeToParent(this.WIDGETS, this.field_147003_i, this.field_147009_r);
        if (this.stack.func_77978_p() != null) {
            this.saveBtn.field_230693_o_ = false;
            this.nameInput.field_230693_o_ = false;
            this.valueInput.field_230693_o_ = false;
            this.nameInput.func_146180_a(this.stack.func_77978_p().func_74779_i("name"));
            String type = this.stack.func_77978_p().func_74779_i("type");
            CompoundNBT nbt = this.stack.func_77978_p();
            switch (type) {
                default: {
                    this.valueInput.func_146180_a("NONE");
                    break;
                }
                case "double": {
                    this.valueInput.func_146180_a(String.valueOf(GSKONBTUtil.getAsNumber(nbt).func_150286_g()));
                    break;
                }
                case "int": {
                    this.valueInput.func_146180_a(String.valueOf(GSKONBTUtil.getAsNumber(nbt).func_150287_d()));
                    break;
                }
                case "float": {
                    this.valueInput.func_146180_a(String.valueOf(GSKONBTUtil.getAsNumber(nbt).func_150288_h()));
                    break;
                }
                case "long": {
                    this.valueInput.func_146180_a(String.valueOf(GSKONBTUtil.getAsNumber(nbt).func_150291_c()));
                    break;
                }
                case "string": {
                    this.valueInput.func_146180_a(GSKONBTUtil.getFromValue(nbt).func_150285_a_());
                    break;
                }
                case "boolean": {
                    if (GSKONBTUtil.getFromValue(nbt) instanceof ByteNBT) {
                        ByteNBT byteNbt = (ByteNBT)GSKONBTUtil.getFromValue(nbt);
                        this.valueInput.func_146180_a(byteNbt.func_150287_d() == 0 ? "false" : "true");
                    }
                    this.valueInput.func_146180_a("false");
                }
            }
        }
    }

    private void presetBtnAction(Button button) {
        this.insertNameAndValue();
        this.constPreset = EnumUtil.switchEnum(ConstPreset.class, this.constPreset);
        button.func_238482_a_(EnumUtil.moveTo(ConstPreset.class, this.constPreset, -1).toTextComponent());
        this.constType = this.constPreset == ConstPreset.NONE ? ConstType.STRING : ConstType.DOUBLE;
        this.constTypeBtn.func_238482_a_(this.constType.toTextComponent());
        this.field_230705_e_.remove(this.constTypeBtn);
    }

    private void saveBtnAction(Button button) {
        if (this.checkPresetForSave()) {
            GSKONetworking.CHANNEL.sendToServer((Object)new CMergeScriptPacket(this.constData));
        }
    }

    private void constTypeBtnAction(Button button) {
        this.constType = EnumUtil.switchEnum(ConstType.class, this.constType);
        button.func_238482_a_(this.constType.toTextComponent());
        this.nameInput.func_146180_a(this.constType.getKey());
        this.valueInput.func_146180_a("");
    }

    protected void func_230450_a_(@NotNull MatrixStack matrixStack, float partialTicks, int x, int y) {
        if (this.field_230706_i_ == null) {
            return;
        }
        if (this.field_230706_i_.field_71439_g == null) {
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void func_230430_a_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.field_230706_i_ != null) {
            this.renderRelativeToParent(this.WIDGETS, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r, partialTicks);
        }
    }

    private void insertNameAndValue() {
        this.checkPresetForInsert();
    }

    private void checkPresetForInsert() {
        switch (this.constPreset) {
            case NONE: {
                this.nameInput.func_146180_a("undefined");
                this.valueInput.func_146180_a("NONE");
                break;
            }
            case TWO_PI: {
                this.nameInput.func_146180_a("double");
                this.valueInput.func_146180_a(String.valueOf(Math.PI * 2));
                break;
            }
            case PI: {
                this.nameInput.func_146180_a("double");
                this.valueInput.func_146180_a(String.valueOf(Math.PI));
                break;
            }
            case E: {
                this.nameInput.func_146180_a("double");
                this.valueInput.func_146180_a(String.valueOf(Math.E));
            }
        }
    }

    private boolean checkPresetForSave() {
        if (this.nameInput.func_146179_b().equals("") || this.valueInput.func_146179_b().equals("")) {
            return false;
        }
        switch (this.constPreset) {
            case NONE: {
                this.tryParse();
                return true;
            }
            case TWO_PI: 
            case PI: 
            case E: {
                this.constData.func_74778_a("type", this.constType.key);
                this.constData.func_74778_a("name", this.nameInput.func_146179_b());
                this.constData.func_218657_a("value", (INBT)DoubleNBT.func_229684_a_((double)this.parseDouble(this.valueInput.func_146179_b())));
                return true;
            }
        }
        this.constData.func_74778_a("type", "undefined");
        this.constData.func_74778_a("name", this.nameInput.func_146179_b());
        this.constData.func_74778_a("value", this.valueInput.func_146179_b());
        return true;
    }

    private void tryParse() {
        this.constData.func_74778_a("type", this.constType.key);
        this.constData.func_74778_a("name", this.nameInput.func_146179_b());
        switch (this.constType) {
            case INT: {
                this.constData.func_218657_a("value", (INBT)IntNBT.func_229692_a_((int)this.parseInt(this.valueInput.func_146179_b())));
                break;
            }
            case LONG: {
                this.constData.func_218657_a("value", (INBT)LongNBT.func_229698_a_((long)this.parseLong(this.valueInput.func_146179_b())));
                break;
            }
            case FLOAT: {
                this.constData.func_218657_a("value", (INBT)FloatNBT.func_229689_a_((float)this.parseFloat(this.valueInput.func_146179_b())));
                break;
            }
            case DOUBLE: {
                this.constData.func_218657_a("value", (INBT)DoubleNBT.func_229684_a_((double)this.parseDouble(this.valueInput.func_146179_b())));
                break;
            }
            case STRING: {
                this.constData.func_218657_a("value", (INBT)StringNBT.func_229705_a_((String)this.valueInput.func_146179_b()));
                break;
            }
            case BOOLEAN: {
                this.constData.func_218657_a("value", (INBT)ByteNBT.func_229672_a_((boolean)Boolean.parseBoolean(this.valueInput.func_146179_b())));
            }
        }
    }

    private void putIntInfo(String type, String name) {
        this.constData.func_74778_a("type", type);
        this.constData.func_74778_a("name", name);
    }
}

