/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.gui.screen.script;

import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.api.client.IInputParser;
import github.thelawf.gensokyoontology.api.client.ITextBuilder;
import github.thelawf.gensokyoontology.api.client.layout.WidgetConfig;
import github.thelawf.gensokyoontology.client.gui.screen.widget.BlankWidget;
import github.thelawf.gensokyoontology.client.gui.screen.widget.SlotWidget;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class LineralContainerScreen<C extends Container>
extends ContainerScreen<C>
implements IInputParser,
ITextBuilder {
    protected final BlankWidget blank = BlankWidget.INSTANCE;
    protected static final int WHITE = 0xFFFFFF;
    protected static final int DARK_GRAY = 0x555555;

    public LineralContainerScreen(C screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void initByConfig(List<WidgetConfig> configs, int x, int y) {
        for (WidgetConfig config : configs) {
            this.addWidget(x += config.leftInterval, y += config.upInterval, config);
        }
    }

    public void setCenteredWidgets(List<WidgetConfig> configs) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        this.initByConfig(configs, x, y);
    }

    public void setAbsoluteXY(List<WidgetConfig> configs) {
        for (WidgetConfig config : configs) {
            int x = config.leftInterval;
            int y = config.upInterval;
            this.addWidget(x, y, config);
        }
    }

    public void setRelativeToParent(List<WidgetConfig> configs, int parentLeft, int parentTop) {
        for (WidgetConfig config : configs) {
            int x = config.leftInterval;
            int y = config.upInterval;
            this.addWidget(x + parentLeft, y + parentTop, config);
        }
    }

    public void drawCenteredText(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        for (WidgetConfig config : configs) {
            x += config.width;
            y += config.height;
            y += config.upInterval;
            if (!config.isText) continue;
            LineralContainerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
        }
    }

    private void addWidget(int x, int y, WidgetConfig config) {
        if (config.widget instanceof Button) {
            config.widget = new Button(x, y, config.width, config.height, config.text, config.action);
            this.func_230480_a_(config.widget);
        }
        if (config.widget instanceof ImageButton) {
            config.widget = new ImageButton(x, y, config.width, config.height, config.u, config.v, 0, config.texture, 256, 256, config.action, config.text);
            this.func_230480_a_(config.widget);
        }
        if (config.widget instanceof TextFieldWidget) {
            config.widget.field_230690_l_ = x;
            config.widget.field_230691_m_ = y;
            config.widget.func_230991_b_(config.width);
            config.widget.setHeight(config.height);
            config.widget.func_238482_a_(config.text);
            this.field_230705_e_.add(config.widget);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderWidgets(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        for (WidgetConfig config : configs) {
            x += config.width;
            y += config.height;
            y += config.upInterval;
            if (config.isText) {
                LineralContainerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
                continue;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderRelativeXY(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (WidgetConfig config : configs) {
            int x = config.leftInterval;
            int y = config.upInterval;
            if (config.isText) {
                LineralContainerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
                continue;
            }
            if (config.widget instanceof SlotWidget) {
                return;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderCenterRelative(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (WidgetConfig config : configs) {
            if (config.isText) {
                LineralContainerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)config.leftInterval, (int)config.upInterval, (int)0xFFFFFF);
                continue;
            }
            if (config.widget instanceof SlotWidget) {
                return;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderRelativeToParent(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, int parentLeft, int parentTop, float partialTicks) {
        for (WidgetConfig config : configs) {
            if (config.isText) {
                LineralContainerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)(parentLeft + config.leftInterval), (int)(parentTop + config.upInterval), (int)0xFFFFFF);
                continue;
            }
            if (config.widget instanceof SlotWidget) {
                return;
            }
            if (config.widget instanceof Button) {
                config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                continue;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }
}

