/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.gui.screen.script;

import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.api.client.IInputParser;
import github.thelawf.gensokyoontology.api.client.ITextBuilder;
import github.thelawf.gensokyoontology.api.client.layout.WidgetConfig;
import github.thelawf.gensokyoontology.client.gui.screen.widget.BlankWidget;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LineralLayoutScreen
extends Screen
implements IInputParser,
ITextBuilder {
    protected final BlankWidget blank = BlankWidget.INSTANCE;
    public static final Logger LOGGER = LogManager.getLogger();

    protected LineralLayoutScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public void initByConfig(List<WidgetConfig> configs, int x, int y) {
        for (WidgetConfig config : configs) {
            this.addWidget(x += config.leftInterval, y += config.upInterval, config);
        }
    }

    public void setCenteredWidgets(List<WidgetConfig> configs) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        this.initByConfig(configs, x, y);
    }

    public void setAbsoluteXY(List<WidgetConfig> configs) {
        for (WidgetConfig config : configs) {
            int x = config.leftInterval;
            int y = config.upInterval;
            this.addWidget(x, y, config);
        }
    }

    private void addWidget(int x, int y, WidgetConfig config) {
        if (config.widget instanceof Button) {
            config.widget = new Button(x, y, config.width, config.height, config.text, config.action);
            this.func_230480_a_(config.widget);
        }
        if (config.widget instanceof TextFieldWidget) {
            config.widget.field_230690_l_ = x;
            config.widget.field_230691_m_ = y;
            config.widget.func_230991_b_(config.width);
            config.widget.setHeight(config.height);
            config.widget.func_238482_a_(config.text);
            this.field_230705_e_.add(config.widget);
        }
    }

    public void drawCenteredText(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        for (WidgetConfig config : configs) {
            x += config.width;
            y += config.height;
            y += config.upInterval;
            if (!config.isText) continue;
            LineralLayoutScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
        }
    }

    public void renderWidgets(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int width = 0;
        int parentWidth = 255;
        for (WidgetConfig config : configs) {
            width += config.width;
        }
        int x = (parentWidth - width) / 2;
        int y = 0;
        for (WidgetConfig config : configs) {
            x += config.width;
            y += config.height;
            y += config.upInterval;
            if (config.isText) {
                LineralLayoutScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
                continue;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void renderAbsoluteXY(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (WidgetConfig config : configs) {
            int x = config.leftInterval;
            int y = config.upInterval;
            if (config.isText) {
                LineralLayoutScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
                continue;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void renderIntervalRelative(List<WidgetConfig> configs, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int x = 0;
        int y = 0;
        for (WidgetConfig config : configs) {
            x += config.leftInterval;
            y += config.upInterval;
            if (config.isText) {
                LineralLayoutScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)config.fontRenderer, (ITextComponent)config.text, (int)x, (int)y, (int)0xFFFFFF);
                continue;
            }
            config.widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }
}

