/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import github.thelawf.gensokyoontology.common.entity.AbstractHumanEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import org.jetbrains.annotations.NotNull;

public class HumanNPCModel<T extends AbstractHumanEntity>
extends BipedModel<T> {
    private List<ModelRenderer> modelRenderers = Lists.newArrayList();
    public final ModelRenderer bipedLeftArmwear;
    public final ModelRenderer bipedRightArmwear;
    public final ModelRenderer bipedLeftLegwear;
    public final ModelRenderer bipedRightLegwear;
    public final ModelRenderer bipedBodyWear;
    private final ModelRenderer bipedCape;
    private final ModelRenderer bipedDeadmau5Head = new ModelRenderer((Model)this, 24, 0);

    public HumanNPCModel(float modelSize) {
        super(RenderType::func_228644_e_, modelSize, 0.0f, 64, 64);
        this.bipedDeadmau5Head.func_228301_a_(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, modelSize);
        this.bipedCape = new ModelRenderer((Model)this, 0, 0);
        this.bipedCape.func_78787_b(64, 32);
        this.bipedCape.func_228301_a_(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, modelSize);
        this.field_178724_i = new ModelRenderer((Model)this, 32, 48);
        this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedLeftArmwear = new ModelRenderer((Model)this, 48, 48);
        this.bipedLeftArmwear.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
        this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedRightArmwear = new ModelRenderer((Model)this, 40, 32);
        this.bipedRightArmwear.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
        this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
        this.field_178722_k = new ModelRenderer((Model)this, 16, 48);
        this.field_178722_k.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedLeftLegwear = new ModelRenderer((Model)this, 0, 48);
        this.bipedLeftLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
        this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedRightLegwear = new ModelRenderer((Model)this, 0, 32);
        this.bipedRightLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
        this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.bipedBodyWear = new ModelRenderer((Model)this, 16, 32);
        this.bipedBodyWear.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSize + 0.25f);
        this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return Iterables.concat((Iterable)super.func_225600_b_(), (Iterable)ImmutableList.of((Object)this.field_178722_k, (Object)this.field_178721_j, (Object)this.field_178724_i, (Object)this.field_178723_h, (Object)this.field_78115_e));
    }

    public void renderEars(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn) {
        this.bipedDeadmau5Head.func_217177_a(this.field_78116_c);
        this.bipedDeadmau5Head.field_78800_c = 0.0f;
        this.bipedDeadmau5Head.field_78797_d = 0.0f;
        this.bipedDeadmau5Head.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void renderCape(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn) {
        this.bipedCape.func_228308_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.bipedLeftLegwear.func_217177_a(this.field_178722_k);
        this.bipedRightLegwear.func_217177_a(this.field_178721_j);
        this.bipedLeftArmwear.func_217177_a(this.field_178724_i);
        this.bipedRightArmwear.func_217177_a(this.field_178723_h);
        this.bipedBodyWear.func_217177_a(this.field_78115_e);
        if (entityIn.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
            if (entityIn.func_213453_ef()) {
                this.bipedCape.field_78798_e = 1.4f;
                this.bipedCape.field_78797_d = 1.85f;
            } else {
                this.bipedCape.field_78798_e = 0.0f;
                this.bipedCape.field_78797_d = 0.0f;
            }
        } else if (entityIn.func_213453_ef()) {
            this.bipedCape.field_78798_e = 0.3f;
            this.bipedCape.field_78797_d = 0.8f;
        } else {
            this.bipedCape.field_78798_e = -1.1f;
            this.bipedCape.field_78797_d = -0.85f;
        }
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        ModelRenderer modelrenderer = this.func_187074_a(sideIn);
        modelrenderer.func_228307_a_(matrixStackIn);
    }

    public ModelRenderer getRandomModelRenderer(Random randomIn) {
        return this.modelRenderers.get(randomIn.nextInt(this.modelRenderers.size()));
    }

    public void accept(@NotNull ModelRenderer p_accept_1_) {
        if (this.modelRenderers == null) {
            this.modelRenderers = Lists.newArrayList();
        }
        this.modelRenderers.add(p_accept_1_);
    }
}

