/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.renderer.entity.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.entity.misc.DestructiveEyeEntity;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;

public class DestructiveEyeRenderer
extends EntityRenderer<DestructiveEyeEntity> {
    private final ItemRenderer itemRenderer;
    public static final ResourceLocation TEXTURE = GensokyoOntology.withRL("textures/entity/sphere_dark");

    public DestructiveEyeRenderer(EntityRendererManager renderManager, ItemRenderer itemRenderer) {
        super(renderManager);
        this.itemRenderer = itemRenderer;
    }

    @NotNull
    public ResourceLocation getEntityTexture(@NotNull DestructiveEyeEntity entity) {
        return TEXTURE;
    }

    public void render(@NotNull DestructiveEyeEntity entityIn, float entityYaw, float partialTicks, @NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        float circumstance = 360.0f;
        float speed = 5.0f;
        float scale = GSKOMathUtil.lerpTicks(partialTicks, entityIn.MAX_LIVING_TICK, entityIn.field_70173_aa, 0.1f, 3.0f);
        float angle = GSKOMathUtil.lerpTicks(partialTicks, entityIn.MAX_LIVING_TICK, entityIn.field_70173_aa, 0.0f, circumstance * speed);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.12, 0.2, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(45.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.itemRenderer.func_229110_a_(new ItemStack((IItemProvider)ItemRegistry.SPHERE_EFFECT_ITEM.get()), ItemCameraTransforms.TransformType.GROUND, 0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(-0.8, 0.2, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-45.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.itemRenderer.func_229110_a_(new ItemStack((IItemProvider)ItemRegistry.SPHERE_EFFECT_ITEM.get()), ItemCameraTransforms.TransformType.GROUND, 0, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }

    public Vector3f toVec3f(Vector3d vector3d) {
        return new Vector3f((float)vector3d.field_72450_a, (float)vector3d.field_72448_b, (float)vector3d.field_72449_c);
    }
}

