/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.renderer.entity.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.entity.misc.DreamSealEntity;
import github.thelawf.gensokyoontology.common.util.math.GeometryUtil;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DreamSealRenderer
extends EntityRenderer<DreamSealEntity> {
    private final ItemRenderer itemRenderer;
    public static final int COLOR = new Random().nextInt(3);
    public static final ResourceLocation TEXTURE = GensokyoOntology.withRL("textures/entity/dream_seal_overlay.png");

    public DreamSealRenderer(EntityRendererManager renderManager, ItemRenderer itemRenderer) {
        super(renderManager);
        this.itemRenderer = itemRenderer;
    }

    public ResourceLocation getEntityTexture(DreamSealEntity entity) {
        return TEXTURE;
    }

    public void render(@NotNull DreamSealEntity entityIn, float entityYaw, float partialTicks, @NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn) {
        float b;
        float g;
        float r;
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(4.0f, 4.0f, 4.0f);
        matrixStackIn.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        switch (entityIn.getDanmakuColor()) {
            case RED: {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
                break;
            }
            case BLUE: {
                r = 0.0f;
                g = 0.0f;
                b = 1.0f;
                break;
            }
            case GREEN: {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
                break;
            }
            default: {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
        }
        GeometryUtil.renderSphere(bufferIn.getBuffer(RenderType.func_228657_l_()), matrixStackIn.func_227866_c_().func_227870_a_(), 10, 10, 0.3f, r, g, b, 0.5f);
        GeometryUtil.renderSphere(bufferIn.getBuffer(RenderType.func_228657_l_()), matrixStackIn.func_227866_c_().func_227870_a_(), 10, 10, 0.2f, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

