/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.renderer.entity.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.client.GSKORenderTypes;
import github.thelawf.gensokyoontology.common.entity.misc.LaserSourceEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LaserEntityRenderer
extends EntityRenderer<LaserSourceEntity> {
    public static final ResourceLocation LASER_SOURCE_TEX = GensokyoOntology.withRL("textures/entity/laser_source.png");
    public static final ResourceLocation LASER_BEAM_TEX = GensokyoOntology.withRL("textures/entity/laser_beam_1.png");
    public static final RenderType LASER_BEAM = RenderType.func_228644_e_((ResourceLocation)LASER_BEAM_TEX);

    public LaserEntityRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    @NotNull
    public ResourceLocation getEntityTexture(@NotNull LaserSourceEntity entity) {
        return LASER_SOURCE_TEX;
    }

    private static void drawSprite(IVertexBuilder builder, Matrix4f matrix4f, TextureAtlasSprite sprite) {
        builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_225587_b_(0, 240).func_181675_d();
        builder.func_227888_a_(matrix4f, 1.0f, 0.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_225587_b_(0, 240).func_181675_d();
        builder.func_227888_a_(matrix4f, 1.0f, 1.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_225587_b_(0, 240).func_181675_d();
        builder.func_227888_a_(matrix4f, 0.0f, 1.0f, 1.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_225587_b_(0, 240).func_181675_d();
    }

    private static void drawLaser(IVertexBuilder builder, Matrix4f matrix4f, Matrix3f matrix3f, float dx1, float dy1, float dz1, int r, int g, int b, float u, float v) {
        builder.func_227888_a_(matrix4f, dx1, dy1, dz1).func_225586_a_(r, g, b, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private void drawLaser(IVertexBuilder vertexBuilder, MatrixStack matrixStack, float length, float red, float green, float blue, float alpha, float thickness) {
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, length, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, thickness, 0.0f, -thickness, red, green, blue, alpha);
        this.vertex(matrixStack, vertexBuilder, -thickness, 0.0f, -thickness, red, green, blue, alpha);
    }

    private void vertex(MatrixStack matrixStack, IVertexBuilder vertexBuilder, float x, float y, float z, float red, float green, float blue, float alpha) {
        vertexBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    private void addVertices(MatrixStack matrixStack, IVertexBuilder builder, Vector3f start, Vector3f end, float red, float green, float blue, float alpha) {
    }

    public void render(@NotNull LaserSourceEntity entityIn, float entityYaw, float partialTicks, @NotNull MatrixStack matrixStackIn, @NotNull IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(LASER_SOURCE_TEX);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(GSKORenderTypes.LASER_LINE);
        float length = entityIn.getRange();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)entityIn.func_70047_e(), 0.0);
        Vector3d vector3d2 = entityIn.func_70040_Z();
        float f5 = (float)Math.acos(vector3d2.field_72448_b);
        float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
        if (entityIn.field_70173_aa <= entityIn.getPreparation()) {
            this.drawLaser(bufferIn.getBuffer(RenderType.func_228657_l_()), matrixStackIn, length, 1.0f, 1.0f, 1.0f, 0.7f, 0.02f);
            matrixStackIn.func_227865_b_();
            return;
        }
        this.drawLaser(bufferIn.getBuffer(RenderType.func_228657_l_()), matrixStackIn, length, this.red(entityIn), this.green(entityIn), this.blue(entityIn), this.alpha(entityIn), 0.15f);
        this.drawLaser(bufferIn.getBuffer(RenderType.func_228657_l_()), matrixStackIn, length, 1.0f, 1.0f, 1.0f, 1.0f, 0.05f);
        matrixStackIn.func_227865_b_();
    }

    private void toLookVec(MatrixStack matrixStack, LaserSourceEntity entityIn) {
        Vector3d vector3d2 = entityIn.func_70040_Z();
        float yaw = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
        float pitch = (float)Math.asin(vector3d2.field_72448_b);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(yaw * 57.295776f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(-pitch * 57.295776f));
    }

    @Deprecated
    private void renderLaserUsingGardianLaser(LaserSourceEntity entityIn, @Nullable Vector3d lookVec, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228657_l_());
        float scale = 0.5f;
        float f1 = (float)entityIn.field_70170_p.func_82737_E() + partialTicks;
        float f2 = f1 * 0.5f % 1.0f;
        float eyeHeight = entityIn.func_70047_e();
        matrixStackIn.func_227860_a_();
        buffer.func_228462_a_(RenderType.func_228657_l_());
        matrixStackIn.func_227861_a_(0.0, (double)eyeHeight, 0.0);
        Vector3d vector3d = entityIn.func_213303_ch();
        Vector3d vector3d1 = entityIn.func_70040_Z().func_186678_a((double)entityIn.getRange());
        float f4 = (float)(vector3d1.func_72433_c() + 1.0);
        Vector3d vector3d2 = entityIn.func_70040_Z();
        float f5 = (float)Math.acos(vector3d2.field_72448_b);
        float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
        float f7 = f1 * 0.05f * -1.5f;
        float f8 = scale * scale;
        int j = 255;
        int k = 255;
        int l = 255;
        int r = entityIn.getRed();
        int g = entityIn.getGreen();
        int b = entityIn.getBlue();
        int a = entityIn.getAlpha();
        float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = MathHelper.func_76134_b((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = MathHelper.func_76126_a((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = MathHelper.func_76134_b((float)(f7 + 0.0f)) * 0.2f;
        float f22 = MathHelper.func_76126_a((float)(f7 + 0.0f)) * 0.2f;
        float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(LASER_BEAM);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.draw(f4, r, g, b, f19, f20, f21, f22, f29, f30, ivertexbuilder, matrix4f, matrix3f);
        this.draw(f4, r, g, b, f23, f24, f25, f26, f29, f30, ivertexbuilder, matrix4f, matrix3f);
        float f31 = 0.0f;
        if (entityIn.field_70173_aa % 2 == 0) {
            f31 = 0.5f;
        }
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, r, g, b, 0.5f, f31 + 0.5f);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, r, g, b, 1.0f, f31 + 0.5f);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, r, g, b, 1.0f, f31);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, r, g, b, 0.5f, f31);
        matrixStackIn.func_227865_b_();
    }

    public boolean shouldRender(LaserSourceEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return super.func_225626_a_((Entity)livingEntityIn, camera, camX, camY, camZ);
    }

    private void draw(float f4, int j, int k, int l, float f19, float f20, float f21, float f22, float f29, float f30, IVertexBuilder ivertexbuilder, Matrix4f matrix4f, Matrix3f matrix3f) {
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
        LaserEntityRenderer.drawLaser(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
    }

    private Vector3f toVec3f(Vector3d v3d) {
        return new Vector3f((float)v3d.field_72450_a, (float)v3d.field_72448_b, (float)v3d.field_72449_c);
    }

    private float red(LaserSourceEntity entityIn) {
        return (float)entityIn.getRed() / 255.0f;
    }

    private float green(LaserSourceEntity entityIn) {
        return (float)entityIn.getGreen() / 255.0f;
    }

    private float blue(LaserSourceEntity entityIn) {
        return (float)entityIn.getBlue() / 255.0f;
    }

    private float alpha(LaserSourceEntity entityIn) {
        return (float)entityIn.getAlpha() / 255.0f;
    }
}

