/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.client.renderer.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.world.BloodyMistCapability;
import github.thelawf.gensokyoontology.common.util.client.GSKOClientUtil;
import github.thelawf.gensokyoontology.common.world.GSKODimensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class BloodyMistRenderer {
    public void setMistColor(EntityViewRenderEvent.FogColors event) {
        event.setRed(1.0f);
        event.setGreen(0.0f);
        event.setBlue(0.0f);
    }

    public void setMistDensity(EntityViewRenderEvent.FogDensity event) {
        event.setDensity(0.8f);
    }

    public void renderBloodyMist(EntityViewRenderEvent.RenderFogEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ServerWorld serverWorld = GSKOClientUtil.getServerWorldFromClient(GSKODimensions.GENSOKYO);
        if (serverWorld != null && this.shouldRender(serverWorld)) {
            return;
        }
        RenderSystem.fogDensity((float)0.8f);
        RenderSystem.fogStart((float)8.0f);
        RenderSystem.fogEnd((float)10.0f);
        RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
    }

    public boolean shouldRender(ServerWorld serverWorld) {
        LazyOptional capability = serverWorld.getCapability(GSKOCapabilities.BLOODY_MIST);
        return !capability.resolve().isPresent() || !((BloodyMistCapability)capability.resolve().get()).isTriggered();
    }
}

