/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.block;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.api.util.INBTWriter;
import github.thelawf.gensokyoontology.common.tileentity.GapTileEntity;
import github.thelawf.gensokyoontology.common.world.TeleportHelper;
import github.thelawf.gensokyoontology.core.init.BlockRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GapBlock
extends Block
implements INBTWriter {
    private BlockPos tilePos;
    protected static final VoxelShape SUKIMA_PLANE_X = Block.func_208617_a((double)-4.0, (double)0.0, (double)4.0, (double)20.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SUKIMA_PLANE_Z = Block.func_208617_a((double)4.0, (double)0.0, (double)-4.0, (double)4.0, (double)16.0, (double)20.0);

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return SUKIMA_PLANE_X;
    }

    public GapBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150427_aO));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GapTileEntity();
    }

    public void func_225542_b_(@NotNull BlockState state, @NotNull ServerWorld worldIn, @NotNull BlockPos pos, @NotNull Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!(placer instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)placer;
        if (stack.func_77978_p() != null) {
            CompoundNBT nbt = stack.func_77978_p();
            this.setBlockTileSecond(player, worldIn, pos, nbt);
            stack.func_77982_d(new CompoundNBT());
            stack.func_190918_g(1);
            return;
        }
        this.setBlockTileFirst(worldIn, player, pos);
    }

    public void func_196262_a(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (!worldIn.field_72995_K && entityIn instanceof ServerPlayerEntity) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entityIn;
            this.tryTeleport(serverWorld, serverPlayer, pos);
        }
    }

    private void setBlockTileFirst(World worldIn, PlayerEntity player, BlockPos firstPos) {
        GapTileEntity gapTile;
        CompoundNBT itemNBT = new CompoundNBT();
        itemNBT.func_74757_a("is_first_placement", true);
        itemNBT.func_74772_a("first_pos", firstPos.func_218275_a());
        if (!worldIn.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)worldIn;
            RegistryKey departureWorld = serverWorld.func_234923_W_();
            itemNBT.func_74778_a("departure_world", departureWorld.func_240901_a_().toString());
            itemNBT.func_74768_a("pos_x", firstPos.func_177958_n());
            itemNBT.func_74768_a("pos_y", firstPos.func_177956_o());
            itemNBT.func_74768_a("pos_z", firstPos.func_177952_p());
            ItemStack itemStack = player.func_184614_ca();
            itemStack.func_77982_d(itemNBT);
            itemStack.func_190917_f(1);
        }
        worldIn.func_175656_a(firstPos, ((Block)BlockRegistry.GAP_BLOCK.get()).func_176223_P());
        if (worldIn.func_175625_s(firstPos) instanceof GapTileEntity && (gapTile = (GapTileEntity)worldIn.func_175625_s(firstPos)) != null) {
            gapTile.func_70296_d();
        }
    }

    private void setBlockTileSecond(PlayerEntity player, World worldIn, BlockPos secondPos, @NotNull CompoundNBT itemNBT) {
        worldIn.func_175656_a(secondPos, ((Block)BlockRegistry.GAP_BLOCK.get()).func_176223_P());
        if (!worldIn.field_72995_K && worldIn.func_175625_s(secondPos) instanceof GapTileEntity) {
            RegistryKey departureKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(itemNBT.func_74779_i("departure_world")));
            if (worldIn.func_73046_m() == null) {
                return;
            }
            ServerWorld depatureWorld = worldIn.func_73046_m().func_71218_a(departureKey);
            if (depatureWorld == null) {
                return;
            }
            ServerWorld arrivalWorld = (ServerWorld)worldIn;
            RegistryKey arrivalKey = arrivalWorld.func_234923_W_();
            BlockPos firstPos = new BlockPos(this.getNBTInt(itemNBT, "pos_x"), this.getNBTInt(itemNBT, "pos_y"), this.getNBTInt(itemNBT, "pos_z"));
            GapTileEntity secondPlacedSukima = (GapTileEntity)arrivalWorld.func_175625_s(secondPos);
            GapTileEntity firstPlacedSukima = (GapTileEntity)depatureWorld.func_175625_s(firstPos);
            if (secondPlacedSukima != null) {
                secondPlacedSukima.setDestinationPos(firstPos);
                secondPlacedSukima.setDestinationWorld((RegistryKey<World>)departureKey);
                secondPlacedSukima.func_70296_d();
            }
            if (firstPlacedSukima != null) {
                firstPlacedSukima.setDestinationPos(secondPos);
                firstPlacedSukima.setDestinationWorld((RegistryKey<World>)arrivalKey);
                firstPlacedSukima.func_70296_d();
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("first_pos")) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("first_pos")) {
                BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("first_pos"));
                tooltip.add((ITextComponent)new StringTextComponent("\u7b2c\u4e00\u5904\u9699\u95f4\u8bbe\u7f6e\u4e3a: " + pos.func_229422_x_()));
            }
            if (nbt.func_74764_b("departure_world")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(nbt.func_74779_i("departure_world")));
            }
        }
    }

    public void tryTeleport(ServerWorld departureWorld, ServerPlayerEntity serverPlayer, BlockPos depaturePos) {
        if (departureWorld.func_175625_s(depaturePos) instanceof GapTileEntity) {
            GapTileEntity departureGap = this.getGapTile(departureWorld, depaturePos);
            ServerWorld destinationWorld = departureWorld.func_73046_m().func_71218_a(departureGap.getDestinationWorld());
            if (departureGap.getCooldown() > 1) {
                return;
            }
            if (destinationWorld == null) {
                serverPlayer.func_146105_b((ITextComponent)GensokyoOntology.withTranslation("msg.", ".gap_block.teleport_fail.destination_not_present"), true);
                return;
            }
            if (this.getGapTile(destinationWorld, departureGap.getDestinationPos()) == null) {
                serverPlayer.func_146105_b((ITextComponent)GensokyoOntology.withTranslation("msg.", ".gap_block.teleport_fail.arrival_gap_not_present"), true);
                return;
            }
            GapTileEntity arrivalGap = this.getGapTile(destinationWorld, departureGap.getDestinationPos());
            arrivalGap.setCooldown(400);
            TeleportHelper.applyGapTeleport(serverPlayer, destinationWorld, departureGap);
            if (departureGap.getDestinationPos() == BlockPos.field_177992_a) {
                serverPlayer.func_146105_b((ITextComponent)GensokyoOntology.withTranslation("msg.", ".gap_block.teleport_fail.illegal_position"), true);
            }
        }
    }

    public GapTileEntity getGapTile(ServerWorld serverWorld, BlockPos pos) {
        return (GapTileEntity)serverWorld.func_175625_s(pos);
    }
}

