/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.block;

import github.thelawf.gensokyoontology.common.tileentity.SpaceFissureTileEntity;
import github.thelawf.gensokyoontology.common.world.GSKODimensions;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceFissureBlock
extends Block {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final VoxelShape shape;

    public SpaceFissureBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(11400.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new SpaceFissureTileEntity();
    }

    public void func_196262_a(BlockState state, @NotNull World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn instanceof ServerWorld && !(entityIn instanceof PlayerEntity)) {
            entityIn.func_70097_a(DamageSource.field_76380_i, 12.0f);
        } else if (worldIn instanceof ServerWorld && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            RegistryKey dimensionKey = entityIn.field_70170_p.func_234923_W_() == World.field_234918_g_ ? GSKODimensions.GENSOKYO : World.field_234918_g_;
            ServerWorld world = ((ServerWorld)worldIn).func_73046_m().func_71218_a(dimensionKey);
            if (world == null) {
                LOGGER.warn("The Dimsion {} on this server does not exist!", (Object)dimensionKey.getRegistryName());
                return;
            }
            entityIn.func_241206_a_(world);
            LOGGER.info("Player {} has been to {}", (Object)((PlayerEntity)entityIn).func_146103_bH().getName(), (Object)dimensionKey.getRegistryName());
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return shape;
    }

    static {
        VoxelShape portalPane = Block.func_208617_a((double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)24.0, (double)8.0);
        shape = VoxelShapes.func_216384_a((VoxelShape)portalPane, (VoxelShape[])new VoxelShape[0]);
    }
}

