/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.block.decoration;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.tileentity.HaniwaTileEntity;
import github.thelawf.gensokyoontology.common.util.GSKOUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HaniwaBlock
extends Block {
    public static final VoxelShape BODY_MAIN = HaniwaBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    public static final VoxelShape BODY_TOP = HaniwaBlock.func_208617_a((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape LEFT_BASE = HaniwaBlock.func_208617_a((double)13.0, (double)5.0, (double)7.0, (double)14.0, (double)8.0, (double)10.0);
    public static final VoxelShape LEFT_ARM = HaniwaBlock.func_208617_a((double)14.0, (double)3.0, (double)8.0, (double)16.0, (double)8.0, (double)10.0);
    public static final VoxelShape RIGHT_BASE = HaniwaBlock.func_208617_a((double)2.0, (double)5.0, (double)7.0, (double)3.0, (double)8.0, (double)10.0);
    public static final VoxelShape RIGHT_ARM_HORIZONTAL = HaniwaBlock.func_208617_a((double)-2.0, (double)6.0, (double)7.0, (double)2.0, (double)8.0, (double)9.0);
    public static final VoxelShape RIGHT_ARM_VERTICAL = HaniwaBlock.func_208617_a((double)-2.0, (double)8.0, (double)7.0, (double)0.0, (double)12.0, (double)9.0);

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return VoxelShapes.func_216384_a((VoxelShape)BODY_MAIN, (VoxelShape[])new VoxelShape[]{BODY_TOP, LEFT_BASE, LEFT_ARM, RIGHT_BASE, RIGHT_ARM_HORIZONTAL, RIGHT_ARM_VERTICAL});
    }

    public HaniwaBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150457_bL));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HaniwaTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        HaniwaTileEntity haniwaTile;
        ServerWorld serverWorld;
        if (!worldIn.field_72995_K && (serverWorld = (ServerWorld)worldIn).func_175625_s(pos) instanceof HaniwaTileEntity && (haniwaTile = (HaniwaTileEntity)serverWorld.func_175625_s(pos)) != null) {
            haniwaTile.setCanAddCount(true);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @NotNull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        HaniwaTileEntity haniwaTile;
        ServerWorld serverWorld;
        if (!worldIn.field_72995_K && (serverWorld = (ServerWorld)worldIn).func_175625_s(pos) instanceof HaniwaTileEntity && (haniwaTile = (HaniwaTileEntity)serverWorld.func_175625_s(pos)) != null) {
            if (!haniwaTile.canAddCount()) {
                player.func_145747_a((ITextComponent)GensokyoOntology.withTranslation("msg.", ".haniwa_block.in_cooldown"), player.func_110124_au());
                return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
            }
            haniwaTile.addFaith(1);
            haniwaTile.setCanAddCount(false);
            haniwaTile.setOwnerId(player.func_110124_au());
            player.func_145747_a((ITextComponent)GensokyoOntology.withTranslation("msg.", ".haniwa_block.added_count"), player.func_110124_au());
            GSKOUtil.showChatMsg(player, haniwaTile.getFaithCount(), 1);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        HaniwaTileEntity haniwaTile;
        ServerWorld serverWorld;
        super.onBlockExploded(state, world, pos, explosion);
        if (!world.field_72995_K && (serverWorld = (ServerWorld)world).func_175625_s(pos) instanceof HaniwaTileEntity && (haniwaTile = (HaniwaTileEntity)serverWorld.func_175625_s(pos)) != null) {
            haniwaTile.setFaith(0);
        }
    }
}

