/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.capability;

import github.thelawf.gensokyoontology.common.capability.entity.BeliefCapability;
import github.thelawf.gensokyoontology.common.capability.entity.ExtraLifeCapability;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerCapability;
import github.thelawf.gensokyoontology.common.capability.entity.SecularLifeCapability;
import github.thelawf.gensokyoontology.common.capability.world.BloodyMistCapability;
import github.thelawf.gensokyoontology.common.capability.world.EternalSummerCapability;
import github.thelawf.gensokyoontology.common.capability.world.ImperishableNightCapability;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public class GSKOCapabilities {
    @CapabilityInject(value=BloodyMistCapability.class)
    public static Capability<BloodyMistCapability> BLOODY_MIST;
    @CapabilityInject(value=ImperishableNightCapability.class)
    public static Capability<ImperishableNightCapability> IMPERISHABLE_NIGHT;
    @CapabilityInject(value=EternalSummerCapability.class)
    public static Capability<EternalSummerCapability> ETERNAL_SUMMER;
    @CapabilityInject(value=GSKOPowerCapability.class)
    public static Capability<GSKOPowerCapability> POWER;
    @CapabilityInject(value=SecularLifeCapability.class)
    public static Capability<SecularLifeCapability> SECULAR_LIFE;
    @CapabilityInject(value=BeliefCapability.class)
    public static Capability<BeliefCapability> BELIEF;
    @CapabilityInject(value=ExtraLifeCapability.class)
    public static Capability<ExtraLifeCapability> EXTRA_LIFE;

    public static void registerCapabilities() {
        GSKOCapabilities.register(BeliefCapability.class);
        GSKOCapabilities.register(GSKOPowerCapability.class);
        GSKOCapabilities.register(SecularLifeCapability.class);
        GSKOCapabilities.register(ExtraLifeCapability.class);
        GSKOCapabilities.register(BloodyMistCapability.class);
        GSKOCapabilities.register(ImperishableNightCapability.class);
        GSKOCapabilities.register(EternalSummerCapability.class);
    }

    private static <T extends INBTSerializable<CompoundNBT>> void register(Class<T> capClass, Capability.IStorage<T> storage) {
        CapabilityManager.INSTANCE.register(capClass, storage, capClass::newInstance);
    }

    public static boolean hasCapability(World world, Capability<?> capability) {
        if (world.field_72995_K) {
            return false;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        return serverWorld.getCapability(capability).isPresent();
    }

    public static Method getCapMethod(PlayerEntity player, Capability<?> capability, String methodName) {
        AtomicReference methodRef = new AtomicReference();
        player.getCapability(capability).ifPresent(cap -> {
            try {
                methodRef.set(cap.getClass().getDeclaredMethod(methodName, new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
        return (Method)methodRef.get();
    }

    public static INBTSerializable<CompoundNBT> getCapInstance(PlayerEntity player, Capability<? extends INBTSerializable<CompoundNBT>> capability) {
        AtomicReference capRef = new AtomicReference();
        player.getCapability(capability).ifPresent(capRef::set);
        return (INBTSerializable)capRef.get();
    }

    public static <T> T getCapIns(PlayerEntity player, Capability<T> capability) {
        AtomicReference capRef = new AtomicReference();
        player.getCapability(capability).ifPresent(cap -> capRef.set(capability.getDefaultInstance()));
        return (T)capRef.get();
    }

    public static Object getAndInvoke(PlayerEntity player, Capability<? extends INBTSerializable<CompoundNBT>> capability, String methodName, Object ... objects) {
        if (GSKOCapabilities.getCapMethod(player, capability, methodName) == null) {
            throw new RuntimeException("Cap not present");
        }
        try {
            return GSKOCapabilities.getCapMethod(player, capability, methodName).invoke(GSKOCapabilities.getCapInstance(player, capability), objects);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Function<Object, Object> getCapFunctor(PlayerEntity player, Capability<T> capability, String methodName) {
        return parameter -> {
            try {
                return GSKOCapabilities.getCapMethod(player, capability, methodName).invoke(GSKOCapabilities.getCapIns(player, capability), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Object getFunctorResult(PlayerEntity player, Capability<T> capability, String methodName, Object ... objects) {
        return GSKOCapabilities.getCapFunctor(player, capability, methodName).apply(objects);
    }

    private static <T extends INBTSerializable<CompoundNBT>> void register(Class<T> capClass) {
        CapabilityManager.INSTANCE.register(capClass, new Capability.IStorage<T>(){

            @Nullable
            public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }, () -> null);
    }
}

