/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.capability.entity;

import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerCapability;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GSKOPowerProvider
implements ICapabilitySerializable<CompoundNBT> {
    private float count;
    private GSKOPowerCapability capability;

    public GSKOPowerProvider(float count) {
        this.count = count;
        this.capability = (GSKOPowerCapability)GSKOCapabilities.POWER.getDefaultInstance();
    }

    public GSKOPowerCapability getOrCreate() {
        if (this.capability == null) {
            this.capability = new GSKOPowerCapability(this.count);
        }
        return this.capability;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == GSKOCapabilities.POWER && this.capability != null ? LazyOptional.of(() -> this.capability).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)GSKOCapabilities.POWER.writeNBT((Object)this.getOrCreate(), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        GSKOCapabilities.POWER.readNBT((Object)this.getOrCreate(), null, (INBT)nbt);
    }
}

