/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.capability.entity;

import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.entity.SecularLifeCapability;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecularLifetimeProvider
implements ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    private long lifetime;
    private SecularLifeCapability capability;

    public SecularLifetimeProvider(long lifetime) {
        this.lifetime = lifetime;
        this.capability = (SecularLifeCapability)GSKOCapabilities.SECULAR_LIFE.getDefaultInstance();
    }

    public SecularLifeCapability getOrCreate() {
        if (this.capability == null) {
            this.capability = new SecularLifeCapability(this.lifetime);
        }
        return this.capability;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == GSKOCapabilities.SECULAR_LIFE && this.capability != null ? LazyOptional.of(() -> this.capability).cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)GSKOCapabilities.SECULAR_LIFE.writeNBT((Object)this.getOrCreate(), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        GSKOCapabilities.SECULAR_LIFE.readNBT((Object)this.getOrCreate(), null, (INBT)nbt);
    }
}

