/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.container;

import com.mojang.datafixers.DataFixUtils;
import github.thelawf.gensokyoontology.core.RecipeRegistry;
import github.thelawf.gensokyoontology.core.init.ContainerRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import github.thelawf.gensokyoontology.data.recipe.DanmakuRecipe;
import github.thelawf.gensokyoontology.data.recipe.GSKORecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DanmakuCraftingContainer
extends Container {
    private final PlayerEntity player;
    private final IItemHandler playerInventory;
    public static final Logger LOGGER = LogManager.getLogger();
    private final CraftingInventory craftingMatrix = new CraftingInventory((Container)this, 5, 5);
    private final IInventory resultInv = new CraftResultInventory();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int DANMAKU_SLOT_COUNT = 29;

    public DanmakuCraftingContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public DanmakuCraftingContainer(int windowId, PlayerInventory playerInventory, IWorldPosCallable callable) {
        super((ContainerType)ContainerRegistry.DANMAKU_CRAFTING_CONTAINER.get(), windowId);
        this.player = playerInventory.field_70458_d;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.addPlayerInventorySlots(playerInventory, 28, 124, 182);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftingMatrix, j + i * 5, 16 + j * 18, 21 + i * 18));
            }
        }
        this.func_75146_a((Slot)new CraftingResultSlot(this.player, this.craftingMatrix, this.resultInv, 0, 170, 58));
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(@NotNull PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.craftingMatrix);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.resultInv);
    }

    protected void updateCraftingResult() {
        if (!this.player.field_70170_p.field_72995_K) {
            DanmakuRecipe recipe;
            World world = this.player.field_70170_p;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this.player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_199510_b().stream().flatMap(iRecipe -> {
                if (iRecipe instanceof DanmakuRecipe) {
                    DanmakuRecipe recipe = (DanmakuRecipe)((Object)iRecipe);
                    return (Stream)DataFixUtils.orElseGet(RecipeRegistry.DANMAKU_RECIPE.func_222148_a((IRecipe)recipe, world, (IInventory)this.craftingMatrix).map(Stream::of), Stream::empty);
                }
                return null;
            }).findFirst();
            if (optional.isPresent() && (recipe = (DanmakuRecipe)((Object)optional.get())).func_77569_a(this.craftingMatrix, world)) {
                itemstack = recipe.func_77572_b(this.craftingMatrix);
            }
            this.resultInv.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 61, itemstack));
        }
    }

    private ItemStack onItemTake(ServerPlayerEntity serverPlayer, IInventory result) {
        DanmakuRecipe recipe;
        ServerWorld world = serverPlayer.func_71121_q();
        Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(RecipeRegistry.DANMAKU_RECIPE, (IInventory)this.craftingMatrix, (World)world);
        if (optional.isPresent() && (recipe = (DanmakuRecipe)((Object)optional.get())).func_77569_a(this.craftingMatrix, (World)world)) {
            ItemStack itemStack = recipe.func_77571_b();
            result.func_70299_a(0, itemStack);
            NonNullList list = recipe.func_192400_c();
            for (int i = 0; i < list.size(); ++i) {
                this.craftingMatrix.func_70298_a(i, this.craftingMatrix.func_70301_a(i) == ItemStack.field_190927_a ? 0 : GSKORecipeHandler.getMinForIngredients((NonNullList<Ingredient>)list));
            }
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_75130_a(@NotNull IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        this.updateCraftingResult();
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private void addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int verAmount, int dx, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
    }

    private void addSlotBox(IInventory inventory, int index, int x, int y, int horAmount, int verAmount, int dx, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(inventory, index, x, y, horAmount, dx);
            y += dy;
        }
    }

    private int addSlotRange(IInventory inventory, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a(new Slot(inventory, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 3, 18, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private void layoutPlayerInventorySlots(PlayerInventory playerInventory, int leftCol, int topRow) {
        this.addSlotBox((IInventory)playerInventory, 9, leftCol, topRow, 9, 3, 18, 18);
        this.addSlotRange((IInventory)playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private void addPlayerInventorySlots(PlayerInventory playerInventory, int left, int top, int hotBarTop) {
        for (int k = 0; k < 3; ++k) {
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i + k * 9 + 9, left + i * 18, top + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, left + l * 18, hotBarTop));
        }
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 10 && index < 46 ? !this.func_75135_a(itemstack1, 1, 10, false) && (index < 37 ? !this.func_75135_a(itemstack1, 37, 46, false) : !this.func_75135_a(itemstack1, 10, 37, false)) : !this.func_75135_a(itemstack1, 10, 46, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    private List<Integer> createRecipeIndexes(Integer ... slots) {
        ArrayList list = new ArrayList();
        return new ArrayList<Integer>(Arrays.asList(slots));
    }

    private boolean matches(IInventory inventoryIn, List<Integer> list) {
        int matchCount = 0;
        for (int i : list) {
            if (inventoryIn.func_70301_a(i).func_77973_b() != ItemRegistry.DANMAKU_SHOT.get()) continue;
            ++matchCount;
        }
        return matchCount == list.size();
    }

    private boolean matches(IInventory inventoryIn, Map<Integer, ItemStack> stackMap) {
        int matchCount = 0;
        int emptyCount = 0;
        List<Object> list = Arrays.asList(stackMap.keySet().toArray());
        for (int i = 0; i < inventoryIn.func_70302_i_(); ++i) {
            if (list.get(i).equals(i)) {
                ++matchCount;
                continue;
            }
            ++emptyCount;
        }
        return matchCount == stackMap.size() && matchCount + emptyCount == inventoryIn.func_70302_i_();
    }

    private boolean isResultMatrixChange(IInventory inventory) {
        Iterator iterator = this.field_75151_b.iterator();
        if (iterator.hasNext()) {
            Slot inventorySlot = (Slot)iterator.next();
            return inventorySlot.func_75216_d();
        }
        return false;
    }
}

