/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.container;

import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.common.tileentity.SorceryExtractorTileEntity;
import github.thelawf.gensokyoontology.common.util.client.GSKOGUIUtil;
import github.thelawf.gensokyoontology.core.init.ContainerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SorceryExtractorContainer
extends Container {
    private final IItemHandler playerInventory;
    public static final Logger LOGGER = LogManager.getLogger();
    public static final List<List<ItemStack>> RECIPES = GSKOGUIUtil.makeRecipes();
    private final IWorldPosCallable POS_CALLABLE = IWorldPosCallable.field_221489_a;
    private final TileEntity tileEntity;
    private final IInventory ingredientInventory = new Inventory(5);
    private final IInventory resultInventory = new Inventory(1);
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int INGREDIENT_SLOT_COUNT = 4;
    private static final int RESULT_SLOT_COUNT = 1;

    public SorceryExtractorContainer(int windowId, World world, BlockPos blockPos, PlayerInventory playerInventory) {
        super((ContainerType)ContainerRegistry.SORCERY_EXTRACTOR_CONTAINER.get(), windowId);
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.tileEntity = world.func_175625_s(blockPos);
        this.addPlayerInventorySlots(28, 128);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                this.addContainerSlot((IItemHandler)itemHandler, 0, 99, 12);
                this.addContainerSlot((IItemHandler)itemHandler, 1, 54, 56);
                this.addContainerSlot((IItemHandler)itemHandler, 2, 145, 56);
                this.addContainerSlot((IItemHandler)itemHandler, 3, 99, 101);
                this.addContainerSlot((IItemHandler)itemHandler, 4, 99, 56);
            });
        }
    }

    private static SorceryExtractorTileEntity getTileEntity(@NotNull PlayerInventory inv, @NotNull PacketBuffer buf) {
        TileEntity te = inv.field_70458_d.field_70170_p.func_175625_s(buf.func_179259_c());
        if (te instanceof SorceryExtractorTileEntity) {
            return (SorceryExtractorTileEntity)te;
        }
        return new SorceryExtractorTileEntity();
    }

    public void func_75134_a(@NotNull PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.func_193327_a(playerIn, playerIn.field_70170_p, this.ingredientInventory);
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
    }

    private void addContainerSlot(IItemHandler itemHandler, int index, int xPos, int yPos) {
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, index, xPos, yPos){

            public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack stack) {
                if (this.getSlotIndex() == 4) {
                    for (int i = 0; i < 4; ++i) {
                        this.getItemHandler().extractItem(i, 1, false);
                    }
                } else {
                    this.getItemHandler().extractItem(4, 1, false);
                }
                return super.func_190901_a(playerEntity, stack);
            }
        });
    }

    private void addResultSlot(IItemHandler itemHandler, int index, int xPos, int yPos) {
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, index, xPos, yPos));
    }

    private void addIngredientSlotOld(IInventory inventory, int index, int xPos, int yPos) {
        this.func_75146_a(new Slot(inventory, index, xPos, yPos){

            public void func_75218_e() {
                super.func_75218_e();
                for (List<ItemStack> recipe : RECIPES) {
                    if (SorceryExtractorContainer.this.matches(SorceryExtractorContainer.this.ingredientInventory, recipe)) {
                        ItemStack stack = new ItemStack((IItemProvider)recipe.get(recipe.size() - 1).func_77973_b());
                        stack.func_190920_e(1);
                        SorceryExtractorContainer.this.resultInventory.func_70299_a(0, stack);
                    }
                    SorceryExtractorContainer.this.func_75142_b();
                }
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                SorceryExtractorContainer.this.resultInventory.func_70299_a(0, ItemStack.field_190927_a);
                return super.func_190901_a(thePlayer, stack);
            }
        });
    }

    private Pair<IInventory, Integer> getMinStack(IInventory inventory) {
        ArrayList<Integer> stackSize = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stackSize.add(inventory.func_70301_a(i).func_190916_E());
        }
        return Pair.of((Object)inventory, Collections.min(stackSize));
    }

    private void addResultSlotOld(IInventory inventory, int index, int xPos, int yPos) {
        this.func_75146_a(new Slot(inventory, index, xPos, yPos){

            @NotNull
            public ItemStack func_190901_a(@NotNull PlayerEntity thePlayer, @NotNull ItemStack stack) {
                for (int i = 0; i < 4; ++i) {
                    SorceryExtractorContainer.this.ingredientInventory.func_70298_a(i, stack.func_190916_E());
                }
                SorceryExtractorContainer.this.func_75142_b();
                return super.func_190901_a(thePlayer, stack);
            }

            protected void func_75208_c(ItemStack stack) {
                super.func_75208_c(stack);
            }
        });
    }

    private boolean matches(IInventory inventory, List<ItemStack> recipes) {
        int i;
        int totalCount = 0;
        int matchCount = 0;
        Logger logger = LogManager.getLogger();
        for (i = 0; i < 4; ++i) {
            if (recipes.get(i).func_77973_b().equals(ItemStack.field_190927_a.func_77973_b())) continue;
            ++totalCount;
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_77973_b().equals(ItemStack.field_190927_a.func_77973_b()) || !inventory.func_70301_a(i).func_77973_b().equals(recipes.get(i).func_77973_b())) continue;
            ++matchCount;
        }
        return totalCount == matchCount;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private void addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int verAmount, int dx, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
    }

    private void addPlayerInventorySlots(int xStart, int yStart) {
        this.addSlotBox(this.playerInventory, 9, xStart, yStart, 9, 3, 18, 18);
        this.addSlotRange(this.playerInventory, 0, xStart, yStart += 58, 9, 18);
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 10 && index < 42 && !this.func_75135_a(itemstack1, 1, 10, false) && !this.func_75135_a(itemstack1, 10, 37, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }
}

