/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.container;

import github.thelawf.gensokyoontology.common.container.script.ScriptBuilderContainer;
import github.thelawf.gensokyoontology.core.init.ContainerRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SpellCardConsoleContainer
extends ScriptBuilderContainer {
    private final TileEntity tileEntity;
    public final IInventory consoleStacks = new Inventory(31);

    public SpellCardConsoleContainer(int id, PlayerEntity player, World world, BlockPos blockPos) {
        super((ContainerType)ContainerRegistry.SPELL_CONSOLE_CONTAINER.get(), player.field_71071_by, id);
        this.tileEntity = world.func_175625_s(blockPos);
        this.addPlayerInventorySlots(47, 168);
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                int index = 0;
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.addArgsSlot((IItemHandler)itemHandler, index, i * 18 + 22, j * 23 + 25);
                        ++index;
                    }
                }
                this.addArgsSlot((IItemHandler)itemHandler, itemHandler.getSlots() - 1, 224, 71);
            });
        }
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    private void addArgsSlot(IItemHandler itemHandler, int index, int xPos, int yPos) {
        this.func_75146_a((Slot)new SlotItemHandler(itemHandler, index, xPos, yPos));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public boolean isAllowedItem(int index) {
        AtomicBoolean flag = new AtomicBoolean();
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> flag.set(itemHandler.getStackInSlot(index).func_190926_b()));
        }
        return flag.get();
    }

    public boolean hasAllowedTag(int index) {
        AtomicBoolean flag = new AtomicBoolean();
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                CompoundNBT nbt = this.getTag(index);
                boolean contains = nbt.func_74764_b("type") && nbt.func_74764_b("value") || nbt.func_74764_b("name");
                flag.set(contains);
            });
        }
        return flag.get();
    }

    public CompoundNBT getTag(int index) {
        AtomicReference nbtAtom = new AtomicReference();
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> nbtAtom.set(itemHandler.getStackInSlot(index).func_77978_p()));
        }
        return (CompoundNBT)nbtAtom.get();
    }

    public ItemStack getOutputStack() {
        AtomicReference stackAtom = new AtomicReference();
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> stackAtom.set(itemHandler.getStackInSlot(itemHandler.getSlots() - 1)));
        }
        return (ItemStack)stackAtom.get();
    }

    @Override
    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0) {
                slot.func_75220_a(stack, itemstack);
            } else if (index >= 10 && index < 67 && !this.func_75135_a(stack, 1, 10, true) && !this.func_75135_a(stack, 10, 37, true)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemStack2 = slot.func_190901_a(playerIn, stack);
            if (index == 0) {
                playerIn.func_71019_a(itemStack2, false);
            }
        }
        return itemstack;
    }
}

