/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AffiliatedEntity
extends Entity {
    private UUID ownerId;
    public static final DataParameter<Optional<UUID>> DATA_OWNER = EntityDataManager.func_187226_a(AffiliatedEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public AffiliatedEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public AffiliatedEntity(EntityType<?> entityTypeIn, UUID ownerId, World worldIn) {
        super(entityTypeIn, worldIn);
        this.ownerId = ownerId;
        this.setOwnerId(this.ownerId);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_OWNER, Optional.empty());
    }

    protected void func_70037_a(@NotNull CompoundNBT compound) {
        UUID uuid = null;
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        }
        if (uuid != null) {
            this.setDataOwner();
        }
    }

    protected void func_213281_b(@NotNull CompoundNBT compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
    }

    public Optional<UUID> getOwnerID() {
        return (Optional)this.field_70180_af.func_187225_a(DATA_OWNER);
    }

    public void setOwnerId(UUID uuid) {
        if (this.ownerId != null) {
            this.field_70180_af.func_187227_b(DATA_OWNER, Optional.of(uuid));
        }
    }

    public void setDataOwner() {
        if (this.field_70170_p instanceof ServerWorld) {
            Optional optionalUUID = (Optional)this.func_184212_Q().func_187225_a(DATA_OWNER);
            optionalUUID.ifPresent(this::setOwnerId);
        }
    }

    public Optional<UUID> getOwnerId() {
        Optional optionalUUID;
        if (this.field_70170_p instanceof ServerWorld && (optionalUUID = (Optional)this.func_184212_Q().func_187225_a(DATA_OWNER)).isPresent()) {
            return optionalUUID;
        }
        return Optional.empty();
    }

    public Vector3d getAimedVec(LivingEntity target) {
        return new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

