/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.ai.goal;

import github.thelawf.gensokyoontology.common.entity.misc.DestructiveEyeEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SummonEyeGoal
extends Goal {
    protected final MobEntity entity;
    private static final int MAX_DISTANCE = 8;
    private static final int MAX_EXECUTE_TICK = 300;
    private int tickExecuted = 0;
    private Path path;

    public SummonEyeGoal(MobEntity entity) {
        this.entity = entity;
    }

    public void func_75246_d() {
        super.func_75246_d();
        LivingEntity target = this.entity.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return;
        }
        this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        double distance = this.entity.func_70068_e((Entity)target);
        if (this.entity.func_70635_at().func_75522_a((Entity)target) && distance < 8.0) {
            this.generateEye(this.entity.field_70170_p, target);
            ++this.tickExecuted;
        }
    }

    private void generateEye(World world, LivingEntity target) {
        if (!world.field_72995_K) {
            boolean canSummon;
            ServerWorld serverWorld = (ServerWorld)world;
            boolean bl = canSummon = serverWorld.getEntities().filter(e -> e.func_200600_R() == EntityRegistry.DESTRUCTIVE_EYE_ENTITY.get()).count() <= 20L;
            if (canSummon) {
                for (int i = 0; i < 3; ++i) {
                    DestructiveEyeEntity eye = new DestructiveEyeEntity(this.entity.field_70170_p);
                    Vector3d vector3d = DanmakuUtil.getRandomPosWithin(8.0f, DanmakuUtil.Plane.XYZ).func_178787_e(target.func_213303_ch());
                    eye.func_70012_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.0f, 0.0f);
                    world.func_217376_c((Entity)eye);
                }
            }
        }
    }

    public void func_75249_e() {
        super.func_75249_e();
        LivingEntity target = this.entity.func_70638_az();
        DestructiveEyeEntity eye = new DestructiveEyeEntity(this.entity.field_70170_p);
        if (target != null) {
            eye.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.0f, 0.0f);
            this.entity.field_70170_p.func_217376_c((Entity)eye);
        }
    }

    public boolean func_75250_a() {
        ServerWorld serverWorld;
        long count;
        LivingEntity target = this.entity.func_70638_az();
        Random random = new Random();
        if (!this.entity.field_70170_p.field_72995_K && (count = (serverWorld = (ServerWorld)this.entity.field_70170_p).getEntities().filter(e -> e.func_200600_R() == EntityRegistry.DESTRUCTIVE_EYE_ENTITY.get()).count()) >= 8L) {
            return false;
        }
        return this.entity.field_70173_aa % 100 == 0 && target != null && target.func_70089_S();
    }

    public boolean func_75253_b() {
        LivingEntity target = this.entity.func_70638_az();
        if (this.tickExecuted >= 300) {
            return false;
        }
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        boolean isPlayerAndCanNotBeAttacked = target instanceof PlayerEntity && (target.func_175149_v() || ((PlayerEntity)target).func_184812_l_());
        return !isPlayerAndCanNotBeAttacked;
    }
}

