/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.misc;

import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.entity.monster.FairyEntity;
import github.thelawf.gensokyoontology.common.entity.monster.YoukaiEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.ScriptedDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.GSKODamageSource;
import github.thelawf.gensokyoontology.common.util.GSKOUtil;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DreamSealEntity
extends ScriptedDanmakuEntity
implements IRayTraceReader {
    private int color;

    public DreamSealEntity(World worldIn, LivingEntity shooter, DanmakuColor color) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)EntityRegistry.DREAM_SEAL_ENTITY.get()), worldIn);
        this.setLifespan(300);
        this.setColor(color);
        this.func_212361_a((Entity)shooter);
        this.setScript(new CompoundNBT());
        this.setTarget((Entity)DreamSealEntity.findTarget(this.field_70170_p, shooter.func_213303_ch(), this.createCubeBox(shooter.func_213303_ch(), 20)));
    }

    public DreamSealEntity(EntityType<? extends AbstractDanmakuEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getShooter() != null && this.getTarget() != null) {
            Vector3d aimedVec = this.getAimedVec(this.getShooter(), this.getTarget());
            float offset = 0.3f / this.getTarget().func_70047_e();
            this.func_70186_c(aimedVec.field_72450_a, aimedVec.field_72448_b - (double)offset, aimedVec.field_72449_c, 1.6f, 0.0f);
            GSKOUtil.log(this.getClass(), this.getTarget().func_213303_ch());
        }
    }

    private boolean isPlayer() {
        AtomicBoolean flag = new AtomicBoolean();
        if (this.getShooter() == null) {
            return false;
        }
        return this.getShooter() instanceof PlayerEntity;
    }

    public static LivingEntity findTarget(World world, Vector3d center, AxisAlignedBB box) {
        EntityPredicate predicate = new EntityPredicate().func_221012_a(entity -> !(entity instanceof PlayerEntity));
        return world.func_225318_b(LivingEntity.class, predicate, null, center.field_72450_a, center.field_72448_b, center.field_72449_c, box);
    }

    @Override
    protected void func_213868_a(@NotNull EntityRayTraceResult result) {
        super.func_213868_a(result);
        if (result.func_216348_a() instanceof AbstractDanmakuEntity) {
            AbstractDanmakuEntity danmaku = (AbstractDanmakuEntity)result.func_216348_a();
            danmaku.func_70106_y();
        }
        if (result.func_216348_a() instanceof YoukaiEntity) {
            YoukaiEntity youkai = (YoukaiEntity)result.func_216348_a();
            float value = youkai.func_110138_aP() < 400.0f ? youkai.func_110138_aP() * 0.1f : youkai.func_110138_aP() * 0.075f;
            youkai.func_70097_a(GSKODamageSource.HAKUREI_POWER, value);
        }
        if (result.func_216348_a() instanceof FairyEntity) {
            FairyEntity fairy = (FairyEntity)result.func_216348_a();
            fairy.func_70097_a(GSKODamageSource.HAKUREI_POWER, fairy.func_110138_aP());
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }
}

