/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.misc;

import github.thelawf.gensokyoontology.api.util.IRayTraceReader;
import github.thelawf.gensokyoontology.common.entity.AffiliatedEntity;
import github.thelawf.gensokyoontology.common.util.GSKODamageSource;
import github.thelawf.gensokyoontology.common.util.danmaku.SpellBehavior;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class LaserSourceEntity
extends AffiliatedEntity
implements IRayTraceReader {
    private int lifespan = 100;
    private int preparation = 30;
    private float range = 128.0f;
    public int argb = -65536;
    private final List<SpellBehavior> behaviors = new ArrayList<SpellBehavior>();
    public static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(LaserSourceEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_LIFESPAN = EntityDataManager.func_187226_a(LaserSourceEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_PREPARATION = EntityDataManager.func_187226_a(LaserSourceEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> DATA_RANGE = EntityDataManager.func_187226_a(LaserSourceEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public LaserSourceEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, null, worldIn);
        this.field_70158_ak = true;
        this.setARGB(-1996554240);
        this.init(100, 30, 128.0f);
    }

    public LaserSourceEntity(World worldIn, Entity owner) {
        super((EntityType)EntityRegistry.LASER_SOURCE_ENTITY.get(), owner.func_110124_au(), worldIn);
        this.field_70158_ak = true;
        this.setARGB(-1996554240);
        this.init(100, 30, 128.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_LIFESPAN, (Object)this.lifespan);
        this.field_70180_af.func_187214_a(DATA_PREPARATION, (Object)this.preparation);
        this.field_70180_af.func_187214_a(DATA_RANGE, (Object)Float.valueOf(this.range));
        this.field_70180_af.func_187214_a(DATA_COLOR, (Object)this.argb);
    }

    @Override
    protected void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("lifespan")) {
            this.lifespan = compound.func_74762_e("lifespan");
            this.setLifespan(compound.func_74762_e("lifespan"));
        }
        if (compound.func_74764_b("preparation")) {
            this.preparation = compound.func_74762_e("preparation");
            this.setPreparation(compound.func_74762_e("preparation"));
        }
        if (compound.func_74764_b("argb")) {
            this.argb = compound.func_74762_e("argb");
            this.setARGB(compound.func_74762_e("argb"));
        }
        if (compound.func_74764_b("range")) {
            this.range = compound.func_74760_g("range");
            this.setRange(compound.func_74760_g("range"));
        }
    }

    @Override
    protected void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("lifespan", this.lifespan);
        compound.func_74768_a("preparation", this.preparation);
        compound.func_74768_a("argb", this.argb);
        compound.func_74776_a("range", this.range);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getRemainingLife() <= 0) {
            this.func_70106_y();
        }
        if (!this.shouldEmit()) {
            return;
        }
        this.behaviors.stream().filter(behavior -> this.field_70173_aa == behavior.keyTick).forEach(behavior -> {
            this.func_70012_b(behavior.pos.field_72450_a, behavior.pos.field_72448_b, behavior.pos.field_72449_c, behavior.rotation.field_189982_i, behavior.rotation.field_189983_j);
            this.func_213293_j(behavior.motion.field_72450_a, behavior.motion.field_72448_b, behavior.motion.field_72449_c);
        });
        Vector3d start = this.func_213303_ch();
        Vector3d end = this.func_70040_Z().func_186678_a((double)this.range).func_178787_e(start);
        Predicate<Entity> canAttack = entity -> this.getOwnerID().isPresent() && entity.func_110124_au() != this.getOwnerID().get();
        if (this.field_70173_aa % 2 == 0 && this.rayTrace(this.field_70170_p, this, start, end).isPresent()) {
            this.rayTrace(this.field_70170_p, this, start, end).ifPresent(entity -> {
                if (canAttack.test((Entity)entity)) {
                    entity.func_70097_a(GSKODamageSource.LASER, 3.0f);
                }
            });
        }
    }

    public void init(int lifespan, int preparation, float range) {
        this.setLifespan(lifespan);
        this.setPreparation(preparation);
        this.setRange(range);
    }

    public int getLifespan() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_LIFESPAN) == 0 ? this.lifespan : (Integer)this.field_70180_af.func_187225_a(DATA_LIFESPAN);
    }

    public int getRemainingLife() {
        return this.getLifespan() - this.field_70173_aa;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
        this.field_70180_af.func_187227_b(DATA_LIFESPAN, (Object)lifespan);
    }

    public int getPreparation() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_PREPARATION) == 0 ? this.preparation : (Integer)this.field_70180_af.func_187225_a(DATA_PREPARATION);
    }

    public boolean shouldEmit() {
        return this.field_70173_aa >= this.getPreparation() && this.field_70173_aa < this.getLifespan();
    }

    public void setPreparation(int preparation) {
        this.preparation = preparation;
        this.field_70180_af.func_187227_b(DATA_PREPARATION, (Object)preparation);
    }

    public float getRange() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_RANGE)).floatValue() == 0.0f ? this.range : ((Float)this.field_70180_af.func_187225_a(DATA_RANGE)).floatValue();
    }

    public void setRange(float range) {
        this.range = range;
        this.field_70180_af.func_187227_b(DATA_RANGE, (Object)Float.valueOf(range));
    }

    public void setARGB(int argb) {
        this.argb = argb;
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)argb);
    }

    public int getARGB() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_COLOR);
    }

    public int getAlpha() {
        return this.getARGB() >> 24 & 0xFF;
    }

    public int getRed() {
        return this.getARGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getARGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getARGB() & 0xFF;
    }
}

