/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.monster;

import github.thelawf.gensokyoontology.common.entity.ai.goal.DamakuAttackGoal;
import github.thelawf.gensokyoontology.common.entity.monster.RetreatableEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.LargeShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.RiceShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.ScaleShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.SmallShotEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class FairyEntity
extends RetreatableEntity
implements IFlyingAnimal {
    private static final int MAX_LIVING_TICK = 3000;

    public FairyEntity(EntityType<? extends RetreatableEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_189654_d(true);
        this.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new DamakuAttackGoal(this, 100.0, 0.6f));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, (double)0.8f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    @NotNull
    protected PathNavigator func_175447_b(@NotNull World worldIn) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        navigator.func_192879_a(false);
        navigator.func_192878_b(true);
        navigator.func_212239_d(true);
        return navigator;
    }

    public void func_241847_a(@NotNull ServerWorld world, @NotNull LivingEntity killedEntity) {
        super.func_241847_a(world, killedEntity);
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 3000) {
            this.func_70106_y();
        }
    }

    public boolean func_213380_a(@NotNull IWorld worldIn, @NotNull SpawnReason spawnReasonIn) {
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public void func_70623_bb() {
        super.func_70623_bb();
    }

    public void func_189654_d(boolean noGravity) {
        super.func_189654_d(true);
    }

    @Override
    public void danmakuAttack(LivingEntity target) {
        Random r1 = new Random(this.func_110124_au().getMostSignificantBits());
        switch (r1.nextInt(4)) {
            case 0: {
                this.aimedShot(target);
                break;
            }
            case 1: {
                this.oddAimedShot(target);
                break;
            }
            case 2: {
                this.spiralShot();
                break;
            }
            default: {
                this.sphereShot();
            }
        }
    }

    private AbstractDanmakuEntity randomSelect() {
        Random r2 = new Random(this.func_110124_au().getLeastSignificantBits());
        switch (r2.nextInt(4)) {
            case 0: {
                return new LargeShotEntity((LivingEntity)this, this.field_70170_p, DanmakuType.LARGE_SHOT, DanmakuColor.BLUE);
            }
            case 1: {
                return new ScaleShotEntity((LivingEntity)this, this.field_70170_p, DanmakuType.SCALE_SHOT, DanmakuColor.RED);
            }
            case 2: {
                return new RiceShotEntity((LivingEntity)this, this.field_70170_p, DanmakuType.RICE_SHOT, DanmakuColor.PURPLE);
            }
        }
        return new SmallShotEntity((LivingEntity)this, this.field_70170_p, DanmakuType.SMALL_SHOT, DanmakuColor.RED);
    }

    private void aimedShot(LivingEntity target) {
        Vector3d direction = new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
        AbstractDanmakuEntity danmaku = this.randomSelect();
        DanmakuUtil.initDanmaku(danmaku, this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0), true);
        danmaku.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 0.7f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)danmaku);
    }

    private void oddAimedShot(Vector3d pos, Vector3d shootVec) {
        AbstractDanmakuEntity danmaku = this.randomSelect();
        DanmakuUtil.initDanmaku(danmaku, pos, true);
        danmaku.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, 0.7f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)danmaku);
    }

    private void oddAimedShot(LivingEntity target) {
        this.aimedShot(target);
        for (int i = 0; i < 2; ++i) {
            Vector3d shootVec = this.getAimedVec(target).func_178785_b(0.31415927f * (float)(i + 1));
            this.oddAimedShot(this.func_213303_ch().func_178787_e(shootVec).func_72441_c(0.0, 1.0, 0.0), shootVec);
            this.oddAimedShot(this.func_213303_ch().func_178787_e(shootVec).func_72441_c(0.0, 1.0, 0.0), shootVec.func_216371_e());
        }
    }

    private void spiralShot() {
        for (int i = 0; i < 4; ++i) {
            Vector3d shootVec = new Vector3d(Vector3f.field_229179_b_).func_178785_b(0.08726647f * (float)this.field_70173_aa).func_178789_a(0.08726647f * (float)this.field_70173_aa).func_178785_b(1.5707964f * (float)i);
            AbstractDanmakuEntity danmaku = this.randomSelect();
            DanmakuUtil.initDanmaku(danmaku, this.func_213303_ch().func_72441_c(0.0, 1.0, 0.0), true);
            danmaku.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, 0.7f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)danmaku);
        }
    }

    private void sphereShot() {
        List<Vector3d> coordinates = DanmakuUtil.spheroidPos(1.0, 20);
        coordinates.forEach(vector3d -> {
            AbstractDanmakuEntity danmaku = this.randomSelect();
            DanmakuUtil.initDanmaku(danmaku, this.func_213303_ch().func_72441_c(vector3d.field_72450_a, 1.2, vector3d.field_72449_c), true);
            danmaku.func_70186_c(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.7f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)danmaku);
        });
    }

    static class RandomFlyGoal
    extends Goal {
        private final FairyEntity parentEntity;

        public RandomFlyGoal(FairyEntity fairy) {
            this.parentEntity = fairy;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.45);
        }
    }
}

