/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.monster;

import com.google.common.collect.ImmutableList;
import github.thelawf.gensokyoontology.api.entity.ISpellCardUser;
import github.thelawf.gensokyoontology.common.entity.ai.goal.FlandreSpellAttackGoal;
import github.thelawf.gensokyoontology.common.entity.ai.goal.GSKOBossGoal;
import github.thelawf.gensokyoontology.common.entity.ai.goal.SpellCardAttackGoal;
import github.thelawf.gensokyoontology.common.entity.ai.goal.SummonEyeGoal;
import github.thelawf.gensokyoontology.common.entity.monster.TsumiBukuroEntity;
import github.thelawf.gensokyoontology.common.entity.monster.YoukaiEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.FullCherryBlossomEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.boss.FlandreSpellAttack;
import github.thelawf.gensokyoontology.common.util.GSKOUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlandreScarletEntity
extends YoukaiEntity
implements ISpellCardUser {
    public FlandreScarletEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.favorability = -10;
    }

    @Override
    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return super.func_241840_a(world, mate);
    }

    protected void func_184651_r() {
        FlandreSpellAttack flandreSpell = new FlandreSpellAttack(this.field_70170_p, this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new SummonEyeGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SpellCardAttackGoal((MobEntity)this, flandreSpell.bossSpell));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 0.8f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{CreatureEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TsumiBukuroEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    @NotNull
    public ActionResultType func_230254_b_(@NotNull PlayerEntity playerIn, @NotNull Hand hand) {
        return super.func_230254_b_(playerIn, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void danmakuAttack(LivingEntity target) {
        ImmutableList list = ImmutableList.of(FlandreSpellAttack::laser, FlandreSpellAttack::sphere);
        ((Consumer)GSKOUtil.rollFrom(list)).accept(this);
    }

    @Override
    public int func_230256_F__() {
        return super.func_230256_F__();
    }

    @Override
    public void func_230260_a__(int time) {
        super.func_230260_a__(time);
    }

    @Override
    @Nullable
    public UUID func_230257_G__() {
        return super.func_230257_G__();
    }

    @Override
    public void func_230259_a_(@Nullable UUID target) {
        super.func_230259_a_(target);
    }

    @Override
    public void func_230258_H__() {
        super.func_230258_H__();
    }

    @Override
    public void spellCardAttack(SpellCardEntity spellCard, int ticksIn) {
        if (spellCard == null) {
            return;
        }
        spellCard.onTick(this.field_70170_p, (Entity)this, ticksIn);
        spellCard.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        this.field_70170_p.func_217376_c((Entity)spellCard);
    }

    public boolean isDoppelganger() {
        return false;
    }

    public static class Doppelganger
    extends FlandreScarletEntity {
        public static final int LIFE = 1000;
        public final FullCherryBlossomEntity SPELL_CARD;

        public Doppelganger(EntityType<? extends TameableEntity> type, World worldIn) {
            super((EntityType<? extends TameableEntity>)((EntityType)EntityRegistry.FLANDRE_DOPPELDANGER.get()), worldIn);
            this.SPELL_CARD = new FullCherryBlossomEntity(this.field_70170_p, (LivingEntity)this);
        }

        @Override
        protected void func_184651_r() {
            this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new FlandreSpellAttackGoal(this, new GSKOBossGoal.Stage(GSKOBossGoal.Type.SPELL_BREAKABLE, 500, false)));
            this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
            this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, (double)0.4f));
            this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 0.8f));
            this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70173_aa >= 1000) {
                this.func_70106_y();
            }
        }

        @Override
        public boolean isDoppelganger() {
            return true;
        }
    }
}

