/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.monster;

import github.thelawf.gensokyoontology.common.entity.ai.goal.DamakuAttackGoal;
import github.thelawf.gensokyoontology.common.entity.monster.RetreatableEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.SmallShotEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class SpectreEntity
extends RetreatableEntity
implements IRendersAsItem,
IFlyingAnimal {
    public SpectreEntity(EntityType<? extends RetreatableEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new DamakuAttackGoal(this, 30.0, 0.6f));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, (double)0.8f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        super.func_184651_r();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d pos = this.func_213303_ch().func_178787_e(new Vector3d(0.2, 0.2, 0.2)).func_178787_e(new Vector3d(GSKOMathUtil.randomRange(-0.2, 0.2), GSKOMathUtil.randomRange(-0.2, 0.2), GSKOMathUtil.randomRange(-0.2, 0.2)));
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, GSKOMathUtil.randomRange(-0.1, 0.1), GSKOMathUtil.randomRange(-0.1, 0.1), GSKOMathUtil.randomRange(-0.1, 0.1));
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegistry.WANDERING_SOUL.get());
    }

    public void func_189654_d(boolean noGravity) {
        super.func_189654_d(true);
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static boolean canMonsterSpawnInLight(EntityType<SpectreEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && SpectreEntity.isValidLightLevel(worldIn, pos, randomIn) && SpectreEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public static boolean isValidLightLevel(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(8);
    }

    @Override
    public void danmakuAttack(LivingEntity target) {
        if (this.field_70173_aa % 10 == 0) {
            Vector3d direction = new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
            SmallShotEntity danmaku = new SmallShotEntity(this.func_70902_q(), this.field_70170_p, DanmakuType.LARGE_SHOT, DanmakuColor.BLUE);
            DanmakuUtil.initDanmaku(danmaku, this.func_213303_ch(), true);
            danmaku.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 0.78f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)danmaku);
        }
    }

    private <D extends AbstractDanmakuEntity> void aimedShot(LivingEntity target) {
    }
}

