/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.projectile;

import github.thelawf.gensokyoontology.common.entity.projectile.FakeLunarEntity;
import github.thelawf.gensokyoontology.common.util.GSKODamageSource;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.SpellData;
import github.thelawf.gensokyoontology.common.util.danmaku.TransformFunction;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public abstract class AbstractDanmakuEntity
extends ThrowableEntity
implements IRendersAsItem {
    private int lifespan = 125;
    protected float damage = 2.0f;
    private int danmakuColor;
    public static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(AbstractDanmakuEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> DATA_DAMAGE = EntityDataManager.func_187226_a(AbstractDanmakuEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> DATA_LIFESPAN = EntityDataManager.func_187226_a(AbstractDanmakuEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected SpellData spellData;
    public TransformFunction function;
    public CompoundNBT compoundNBT = new CompoundNBT();

    protected AbstractDanmakuEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public AbstractDanmakuEntity(EntityType<? extends ThrowableEntity> type, LivingEntity throwerIn, World world, SpellData spellData) {
        this(type, world);
        this.spellData = spellData;
        this.damage = spellData.danmakuType.damage;
        this.func_70029_a(world);
    }

    public AbstractDanmakuEntity(EntityType<? extends ThrowableEntity> type, LivingEntity throwerIn, World worldIn, DanmakuType danmakuTypeIn, DanmakuColor danmakuColorIn) {
        super(type, worldIn);
        this.damage = danmakuTypeIn.damage;
        this.danmakuColor = danmakuColorIn.ordinal();
        this.func_70029_a(worldIn);
        this.setDanmakuColor(danmakuColorIn);
        this.func_212361_a((Entity)throwerIn);
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
        this.field_70180_af.func_187227_b(DATA_LIFESPAN, (Object)lifespan);
    }

    public int getLifespan() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_LIFESPAN);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa >= this.lifespan) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("damage")) {
            this.damage = compound.func_74760_g("damage");
        }
        if (compound.func_74764_b("color")) {
            this.danmakuColor = compound.func_74762_e("color");
        }
        if (compound.func_74764_b("lifespan")) {
            this.lifespan = compound.func_74762_e("lifespan");
            this.field_70180_af.func_187227_b(DATA_LIFESPAN, (Object)this.lifespan);
        }
    }

    protected void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("color", this.danmakuColor);
        compound.func_74768_a("lifespan", this.getLifespan());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_DAMAGE, (Object)Float.valueOf(this.damage));
        this.field_70180_af.func_187214_a(DATA_COLOR, (Object)this.danmakuColor);
        this.field_70180_af.func_187214_a(DATA_LIFESPAN, (Object)this.lifespan);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_212361_a(@Nullable Entity entityIn) {
        super.func_212361_a(entityIn);
    }

    @Nullable
    public LivingEntity getShooter() {
        return (LivingEntity)super.func_234616_v_();
    }

    public void func_189654_d(boolean noGravity) {
        super.func_189654_d(noGravity);
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_213868_a(@NotNull EntityRayTraceResult result) {
        AbstractDanmakuEntity danmakuEntity;
        if (this.getShooter() instanceof MonsterEntity || this.getShooter() instanceof IAngerable) {
            if (result.func_216348_a() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)result.func_216348_a();
                if (this instanceof FakeLunarEntity) {
                    player.func_70097_a(GSKODamageSource.DANMAKU, 12.0f);
                }
                player.func_70097_a(GSKODamageSource.DANMAKU, this.damage);
            } else if (result.func_216348_a() instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)result.func_216348_a();
                if (this instanceof FakeLunarEntity) {
                    living.func_70097_a(GSKODamageSource.DANMAKU, 12.0f);
                }
            }
            this.func_70106_y();
            return;
        }
        if (result.func_216348_a() instanceof AbstractDanmakuEntity && (danmakuEntity = (AbstractDanmakuEntity)result.func_216348_a()) instanceof FakeLunarEntity) {
            this.func_70106_y();
            return;
        }
        if (!(result.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entityHit = (LivingEntity)result.func_216348_a();
        if (!(entityHit instanceof PlayerEntity)) {
            entityHit.func_70097_a(GSKODamageSource.DANMAKU, this.damage);
            this.func_70106_y();
        }
    }

    public void setDanmakuColor(DanmakuColor danmakuColor) {
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)danmakuColor.ordinal());
    }

    public AbstractDanmakuEntity setColor(DanmakuColor danmakuColor) {
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)danmakuColor.ordinal());
        return this;
    }

    public DanmakuColor getDanmakuColor() {
        return DanmakuColor.values()[(Integer)this.field_70180_af.func_187225_a(DATA_COLOR)];
    }

    public DanmakuType getDanmakuType() {
        return DanmakuType.values()[0];
    }
}

