/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.projectile;

import github.thelawf.gensokyoontology.common.entity.projectile.ScriptedDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.TransformFunction;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class HeartShotEntity
extends ScriptedDanmakuEntity
implements IRendersAsItem {
    public HeartShotEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public HeartShotEntity(LivingEntity throwerIn, World worldIn, CompoundNBT scriptIn) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)EntityRegistry.HEART_SHOT_ENTITY.get()), throwerIn, worldIn, DanmakuType.HEART_SHOT, scriptIn);
    }

    private void applyTransform(HashMap<Integer, TransformFunction> keyTransforms) {
        for (Map.Entry<Integer, TransformFunction> entry : keyTransforms.entrySet()) {
            Integer keyTick = entry.getKey();
            TransformFunction function = entry.getValue();
            if (function.transformOrders != null) continue;
            return;
        }
    }

    @Override
    public void onScriptTick() {
        super.onScriptTick();
        ListNBT inbts = this.getBehaviors(this.scriptsNBT);
        for (INBT inbt : inbts) {
            CompoundNBT behavior = this.wrapAsCompound(inbt);
            if (!behavior.func_74764_b("addMotion") || !(behavior.func_74781_a("addMotion") instanceof ListNBT)) continue;
            List<Double> paramList = this.wrapAsDoubleFromList((ListNBT)behavior.func_74781_a("addMotion"));
            if (paramList.size() != 3) {
                return;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c(paramList.get(0).doubleValue(), paramList.get(1).doubleValue(), paramList.get(2).doubleValue()).func_72432_b());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        IItemProvider item = null;
        switch (this.getDanmakuColor()) {
            case RED: 
            case YELLOW: 
            case GREEN: 
            case PURPLE: 
            case NONE: {
                item = (IItemProvider)ItemRegistry.HEART_SHOT_RED.get();
                break;
            }
            case AQUA: {
                item = (IItemProvider)ItemRegistry.HEART_SHOT_AQUA.get();
                break;
            }
            case BLUE: {
                item = (IItemProvider)ItemRegistry.HEART_SHOT_BLUE.get();
                break;
            }
            case PINK: {
                item = (IItemProvider)ItemRegistry.HEART_SHOT_PINK.get();
            }
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item);
    }
}

