/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.projectile;

import github.thelawf.gensokyoontology.core.init.PotionRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class LovePotionEntity
extends PotionEntity
implements IRendersAsItem {
    public static final EntityType<LovePotionEntity> LOVE_POTION_TYPE = EntityType.Builder.func_220322_a(LovePotionEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10).func_206830_a("love_potion_entity");
    private static final DataParameter<Optional<UUID>> LOVE_MASTER = EntityDataManager.func_187226_a(LovePotionEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public LovePotionEntity(EntityType<? extends PotionEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LOVE_MASTER, Optional.of(Objects.requireNonNull(this.func_234616_v_()).func_110124_au()));
    }

    public ItemStack func_184543_l() {
        return Items.field_151068_bn.func_190903_i();
    }

    public void func_70227_a(@NotNull RayTraceResult result) {
        boolean flag;
        ItemStack stack = this.func_184543_l();
        Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
        List list = PotionUtils.func_185189_a((ItemStack)stack);
        boolean bl = flag = potion == PotionRegistry.LOVE_POTION.get();
        if (flag) {
            // empty if block
        }
    }

    public void applyEffect(List<EffectInstance> listIn, @Nullable Entity entityIn) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.func_184603_cC() || !((d0 = this.func_70068_e((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == listIn) {
                    d1 = 1.0;
                }
                for (EffectInstance effectinstance : listIn) {
                    Effect effect = effectinstance.func_188419_a();
                    if (effect.func_76403_b()) {
                        effect.func_180793_a((Entity)this, this.func_234616_v_(), livingentity, effectinstance.func_76458_c(), d1);
                        continue;
                    }
                    int i = (int)(d1 * (double)effectinstance.func_76459_b() + 0.5);
                    if (i <= 20) continue;
                    livingentity.func_195064_c(new EffectInstance(effect, i, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
                }
            }
        }
    }

    @Nullable
    public Entity func_234616_v_() {
        return super.func_234616_v_();
    }
}

