/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.projectile;

import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptedDanmakuEntity
extends AbstractDanmakuEntity {
    protected CompoundNBT scriptsNBT = new CompoundNBT();
    protected Entity target;
    public static final DataParameter<CompoundNBT> DATA_SCRIPT = EntityDataManager.func_187226_a(ScriptedDanmakuEntity.class, (IDataSerializer)DataSerializers.field_192734_n);

    protected ScriptedDanmakuEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ScriptedDanmakuEntity(EntityType<? extends ThrowableEntity> type, LivingEntity throwerIn, World worldIn, DanmakuType danmakuType, CompoundNBT scriptIn) {
        super(type, throwerIn, worldIn, danmakuType, ScriptedDanmakuEntity.getColorFrom(scriptIn));
        this.setDanmakuColor(ScriptedDanmakuEntity.getColorFrom(this.scriptsNBT));
        this.setScript(scriptIn);
        this.setColor(DanmakuColor.values()[scriptIn.func_74762_e("color")]);
    }

    public static DanmakuColor getColorFrom(CompoundNBT scriptsNBT) {
        if (scriptsNBT != null && scriptsNBT.func_74764_b("color")) {
            return DanmakuColor.values()[scriptsNBT.func_74762_e("color")];
        }
        return DanmakuColor.NONE;
    }

    protected ListNBT wrapAsList(INBT inbt) {
        if (inbt instanceof ListNBT) {
            return (ListNBT)inbt;
        }
        return new ListNBT();
    }

    protected CompoundNBT wrapAsCompound(INBT inbt) {
        if (inbt instanceof CompoundNBT) {
            return (CompoundNBT)inbt;
        }
        return new CompoundNBT();
    }

    protected List<Double> wrapAsDoubleFromList(ListNBT listNBT) {
        ArrayList<Double> list = new ArrayList<Double>();
        listNBT.forEach(inbt -> {
            if (inbt instanceof DoubleNBT) {
                list.add(((DoubleNBT)inbt).func_150286_g());
            }
        });
        return list;
    }

    protected ListNBT getBehaviors(CompoundNBT script) {
        if (script.func_74779_i("type").equals("keyTickBehavior")) {
            return this.wrapAsList(script.func_74781_a("behaviors"));
        }
        return new ListNBT();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SCRIPT, (Object)this.scriptsNBT);
    }

    @Override
    protected void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.scriptsNBT = compound.func_74775_l("script");
        this.field_70180_af.func_187227_b(DATA_SCRIPT, (Object)this.scriptsNBT);
        this.setColor(DanmakuColor.values()[compound.func_74762_e("color")]);
    }

    @Override
    protected void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("script", (INBT)this.scriptsNBT);
        compound.func_74768_a("color", this.scriptsNBT.func_74762_e("color"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.onScriptTick();
    }

    public void setScript(CompoundNBT scriptsNBT) {
        this.scriptsNBT = scriptsNBT;
        this.field_70180_af.func_187227_b(DATA_SCRIPT, (Object)scriptsNBT);
    }

    public CompoundNBT getScript() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(DATA_SCRIPT);
    }

    public Entity getTarget() {
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            return serverWorld.func_217461_a(this.scriptsNBT.func_186857_a("target"));
        }
        return null;
    }

    public static Entity getTargetFrom(World world, CompoundNBT scriptsNBT) {
        if (!world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            return serverWorld.func_217461_a(scriptsNBT.func_186857_a("target"));
        }
        return null;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
        if (target != null) {
            this.getScript().func_186854_a("target", target.func_110124_au());
            this.setScript(this.getScript());
        }
    }

    public void onScriptTick() {
        ListNBT list2 = this.getBehaviors(this.scriptsNBT);
        for (INBT inbt2 : list2) {
            int keyTick;
            List<Double> paramList;
            CompoundNBT behavior = this.wrapAsCompound(inbt2);
            if (behavior.func_74764_b("shoot") && behavior.func_74781_a("shoot") instanceof ListNBT) {
                paramList = this.wrapAsDoubleFromList((ListNBT)behavior.func_74781_a("shoot"));
                keyTick = behavior.func_74762_e("keyTick");
                if (paramList.size() != 4) {
                    return;
                }
                if (this.field_70173_aa == keyTick) {
                    this.func_70186_c(paramList.get(0), paramList.get(1), paramList.get(2), paramList.get(3).floatValue(), 0.0f);
                }
            }
            if (!behavior.func_74764_b("setMotion") || !(behavior.func_74781_a("setMotion") instanceof ListNBT)) continue;
            paramList = this.wrapAsDoubleFromList((ListNBT)behavior.func_74781_a("setMotion"));
            keyTick = behavior.func_74762_e("keyTick");
            if (paramList.size() != 3) {
                return;
            }
            Vector3d motion = new Vector3d(paramList.get(0).doubleValue(), paramList.get(1).doubleValue(), paramList.get(2).doubleValue());
            if (this.field_70173_aa != keyTick) continue;
            this.func_213317_d(motion.func_72432_b());
        }
    }
}

