/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spawn;

import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.common.util.world.GSKOWorldUtil;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.server.ServerWorld;

public class LilyWhiteSpawner {
    public static void spawn(ServerWorld serverWorld, PlayerEntity player, BlockPos pos, int ticks, float chance) {
        Random random = new Random();
        if (LilyWhiteSpawner.validateCondition(serverWorld, ticks, random, chance) && LilyWhiteSpawner.validateSpawnPos(player, serverWorld)) {
            ((EntityType)EntityRegistry.LILY_WHITE_ENTITY.get()).func_220331_a(serverWorld, null, null, pos, SpawnReason.NATURAL, false, false);
        }
    }

    public static boolean validateCondition(ServerWorld serverWorld, int ticks, Random random, float chance) {
        return GSKOMathUtil.isBetween(ticks % 20000, 0, 10) && random.nextFloat() <= chance && serverWorld.getEntities().noneMatch(entity -> entity.func_200600_R() == EntityRegistry.LILY_WHITE_ENTITY.get());
    }

    public static boolean validateSpawnPos(PlayerEntity player, ServerWorld world) {
        Random random = new Random();
        Vector3d lowerPos = DanmakuUtil.getRandomPos(player.func_213303_ch(), new Vector3f(3.0f, 3.0f, 3.0f));
        boolean flag = false;
        for (int i = 0; i < 256; ++i) {
            BlockPos pos = new BlockPos(lowerPos.func_82615_a(), (double)i, lowerPos.func_82616_c());
            BlockPos upperPos = new BlockPos(lowerPos.func_82615_a(), (double)(i + 2), lowerPos.func_82616_c());
            BlockPos middlePos = new BlockPos(lowerPos.func_82615_a(), (double)(i + 1), lowerPos.func_82616_c());
            BlockState eyeBlock = world.func_180495_p(upperPos);
            BlockState middleBlock = world.func_180495_p(middlePos);
            BlockState standBlock = world.func_180495_p(pos);
            if (!eyeBlock.equals(Blocks.field_150350_a.func_176223_P()) || !middleBlock.equals(Blocks.field_150350_a.func_176223_P()) || standBlock.func_177230_c().equals(Blocks.field_150350_a)) continue;
            flag = true;
            break;
        }
        return flag && GSKOWorldUtil.isEntityInBiome((Entity)player, GSKOBiomes.HAKUREI_SHRINE_PRECINCTS_KEY);
    }
}

