/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.RiceShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FullCherryBlossomEntity
extends SpellCardEntity {
    public FullCherryBlossomEntity(World worldIn, LivingEntity living) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.FULL_CHERRY_BLOSSOM_ENTITY.get()), worldIn, living);
        this.setOwner((Entity)living);
    }

    public FullCherryBlossomEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void onTick(World world, LivingEntity living, int ticksExisted) {
        List<Vector3d> roseLinePos = DanmakuUtil.getRoseLinePos(1.2, 3.0, 2.0, 0.05);
        if (ticksExisted % 20 == 0) {
            for (Vector3d vector3d : roseLinePos) {
                RiceShotEntity riceShot = new RiceShotEntity(living, world, DanmakuType.RICE_SHOT, DanmakuColor.PURPLE);
                Vector3d shootVec = new Vector3d(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                shootVec = DanmakuUtil.rotateRandomAngle(shootVec, (float)Math.PI * 2, (float)Math.PI * 2);
                vector3d = vector3d.func_178787_e(DanmakuUtil.getRandomPosWithin(3.5f, DanmakuUtil.Plane.XYZ));
                vector3d = vector3d.func_178787_e(this.func_213303_ch());
                DanmakuUtil.initDanmaku(riceShot, vector3d, new Vector2f((float)vector3d.field_72450_a, (float)vector3d.field_72448_b), true);
                riceShot.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, 0.3f, 0.0f);
                world.func_217376_c((Entity)riceShot);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.onTick(this.field_70170_p, (LivingEntity)this.getOwner(), this.field_70173_aa);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }
}

