/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.SmallStarShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class GalacticArmSpellEntity
extends SpellCardEntity {
    private List<SmallStarShotEntity> list;
    private static final int COUNT = 60;
    private ArrayList<List<SmallStarShotEntity>> starLists = new ArrayList();
    private final List<List<UUID>> idList = new ArrayList<List<UUID>>();
    private final float[] as = new float[]{2.0f, 3.0f, 5.0f, 7.0f, 9.0f, 11.0f, 14.0f, 18.0f, 23.0f, 25.0f};
    private final float[] bs = new float[]{1.0f, 1.2f, 2.5f, 4.0f, 5.0f, 5.5f, 7.2f, 8.0f, 10.3f, 12.0f};

    public GalacticArmSpellEntity(World worldIn, LivingEntity living) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.GALACTIC_ARM_SPELL_ENTITY.get()), worldIn, living);
        this.list = this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60);
        for (int i = 0; i < 10; ++i) {
            this.starLists.add(this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60));
        }
    }

    public GalacticArmSpellEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        super(entityTypeIn, worldIn);
        this.list = this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60);
        for (int i = 0; i < 10; ++i) {
            this.starLists.add(this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60));
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            try {
                this.tryShoot();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void tryShoot() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        int i;
        float speed = 0.06f;
        Vector3d startPos = this.func_213303_ch().func_72441_c(1.0, 0.0, 0.0);
        ArrayList<UUID> ids = new ArrayList<UUID>();
        if (this.field_70173_aa % 200 == 0) {
            this.list = this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60);
            for (i = 0; i < this.starLists.size(); ++i) {
                this.starLists.set(i, this.newDanmakuList(() -> new SmallStarShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.STAR_SHOT_SMALL, DanmakuColor.BLUE), SmallStarShotEntity.class, 60));
            }
        }
        for (i = 0; i < this.as.length; ++i) {
            float a = this.as[i];
            float b = this.bs[i];
            for (int j = 0; j < this.starLists.get(i).size(); ++j) {
                SmallStarShotEntity entity = this.starLists.get(i).get(j);
                double angle = (double)(this.field_70170_p.func_82737_E() + (long)j) * 0.1 % (Math.PI * 2);
                Vector3d nextPos = new Vector3d(startPos.field_72450_a + (double)(a * MathHelper.func_76134_b((float)((float)angle))), startPos.field_72448_b, startPos.field_72449_c + (double)(b * MathHelper.func_76126_a((float)((float)angle))));
                double motionX = -a * MathHelper.func_76126_a((float)((float)angle)) * speed;
                double motionZ = b * MathHelper.func_76134_b((float)((float)angle)) * speed;
                this.setDanmakuInit(entity, startPos, new Vector2f(this.field_70177_z, this.field_70125_A));
                entity.func_70107_b(nextPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c);
                entity.func_213293_j(motionX, 0.0, motionZ);
                this.list.set(j, entity);
                ids.add(entity.func_110124_au());
            }
            this.starLists.add(this.list);
            this.idList.add(ids);
            if (this.starLists.get(i).size() - 1 == 0) {
                return;
            }
            SmallStarShotEntity shot = this.starLists.get(i).get(GSKOMathUtil.clampPeriod(this.field_70173_aa, 0, this.starLists.get(i).size() - 1));
            this.field_70170_p.func_217376_c((Entity)shot);
            this.starLists.get(i).remove(GSKOMathUtil.clampPeriod(this.field_70173_aa, 0, this.starLists.get(i).size() - 1));
        }
    }

    private void trySetDanmaku(ServerWorld serverWorld) {
        float speed = 0.06f;
        Vector3d startPos = this.func_213303_ch().func_72441_c(1.0, 0.0, 0.0);
        for (int i = 0; i < this.as.length; ++i) {
            float a = this.as[i];
            float b = this.bs[i];
            for (int j = 0; j < this.idList.get(i).size(); ++j) {
                SmallStarShotEntity entity = (SmallStarShotEntity)serverWorld.func_217461_a(this.idList.get(i).get(j));
                double angle = (double)(this.field_70170_p.func_82737_E() + (long)j) * 0.1 % (Math.PI * 2);
                Vector3d nextPos = new Vector3d(startPos.field_72450_a + (double)(a * MathHelper.func_76134_b((float)((float)angle))), startPos.field_72448_b, startPos.field_72449_c + (double)(b * MathHelper.func_76126_a((float)((float)angle))));
                double motionX = -a * MathHelper.func_76126_a((float)((float)angle)) * speed;
                double motionZ = b * MathHelper.func_76134_b((float)((float)angle)) * speed;
                if (entity == null) continue;
                this.setDanmakuInit(entity, startPos, new Vector2f(this.field_70177_z, this.field_70125_A));
                entity.func_213293_j(motionX, 0.0, motionZ);
            }
        }
    }

    @Override
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }
}

