/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.FakeLunarEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.SmallShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class HellEclipseEntity
extends SpellCardEntity {
    private final FakeLunarEntity fakeLunar;

    public HellEclipseEntity(World worldIn, PlayerEntity player) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.HELL_ECLIPSE_ENTITY.get()), worldIn, player);
        this.setOwner(player.getEntity());
        this.fakeLunar = new FakeLunarEntity((LivingEntity)player, this.field_70170_p, DanmakuType.FAKE_LUNAR, DanmakuColor.NONE);
        this.fakeLunar.setLifespan(this.lifeSpan);
        this.setDanmakuInit(this.fakeLunar, this.func_213303_ch(), new Vector2f(this.field_70177_z, this.field_70125_A));
        worldIn.func_217376_c((Entity)this.fakeLunar);
    }

    public HellEclipseEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World world) {
        super(entityTypeIn, world);
        this.fakeLunar = new FakeLunarEntity((EntityType<? extends ThrowableEntity>)((EntityType)EntityRegistry.FAKE_LUNAR_ENTITY.get()), world);
        world.func_217376_c((Entity)this.fakeLunar);
        HashMap map = new HashMap();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.onTick(this.field_70170_p, this.getOwner(), this.field_70173_aa);
        this.onScriptTick(this.field_70170_p, this.getOwner(), this.field_70173_aa);
    }

    @Override
    public void onTick(World world, Entity entity, int ticksIn) {
        super.onTick(world, entity, ticksIn);
        Vector3d center = new Vector3d(Vector3f.field_229179_b_);
        float angle = (float)(0.05235987755982988 * (double)this.field_70173_aa);
        float lunarAngle = (float)((double)((float)world.func_82737_E() * 0.1f) % (Math.PI * 2));
        float angle2 = (float)((double)((float)world.func_82737_E() * 0.08f) % (Math.PI * 2));
        float speed = 0.2f;
        Vector3d local = center.func_72441_c(4.0, 0.0, 0.0).func_178785_b(angle);
        Vector3d global = local.func_178787_e(this.func_213303_ch());
        Vector3d lunarPos = this.fakeLunar.func_213303_ch();
        Vector3d lunarMotion = new Vector3d((double)(MathHelper.func_76134_b((float)lunarAngle) * speed), 0.0, (double)(MathHelper.func_76126_a((float)lunarAngle) * speed));
        this.fakeLunar.func_70107_b(lunarPos.field_72450_a + lunarMotion.field_72450_a, lunarPos.field_72448_b, lunarPos.field_72449_c + lunarMotion.field_72449_c);
        this.fakeLunar.func_213317_d(lunarMotion);
        for (int i = 0; i < 8; ++i) {
            SmallShotEntity smallShot = new SmallShotEntity((LivingEntity)this.getOwner(), world, DanmakuType.LARGE_SHOT, DanmakuColor.RED);
            Vector3d vector3d = center.func_178785_b((float)(0.7853981633974483 * (double)i)).func_178785_b((float)(0.031415926535897934 * (double)this.field_70173_aa));
            smallShot.func_70012_b(global.field_72450_a, global.field_72448_b, global.field_72449_c, (float)center.field_72448_b, (float)center.field_72449_c);
            smallShot.func_189654_d(true);
            smallShot.func_70186_c(vector3d.field_72450_a, 0.0, vector3d.field_72449_c, 0.5f, 0.0f);
            world.func_217376_c((Entity)smallShot);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegistry.SC_HELL_ECLIPSE.get());
    }
}

