/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.HeartShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ManiaDepressEntity
extends SpellCardEntity {
    public ManiaDepressEntity(World worldIn, PlayerEntity player) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.MANIA_DEPRESS_ENTITY.get()), worldIn, player);
    }

    public ManiaDepressEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List<Vector3d> pinkPositions = DanmakuUtil.getHeartLinePos(0.3f, 0.11);
        List<Vector3d> aquaPositions = DanmakuUtil.getHeartLinePos(1.8f, 0.11);
        int shootInterval = 15;
        int ratio = this.field_70173_aa / shootInterval;
        pinkPositions = DanmakuUtil.getRotatedPos(pinkPositions, 0.2617994f * (float)ratio, 0.0f);
        aquaPositions = DanmakuUtil.getRotatedPos(aquaPositions, 1.5707964f, 0.0f);
        aquaPositions = DanmakuUtil.getRotatedPos(aquaPositions, 0.5235988f * (float)ratio, 0.0f);
        if (this.field_70173_aa % shootInterval == 0) {
            Vector3d shootVec;
            CompoundNBT nbt;
            for (Vector3d vector3d : pinkPositions) {
                nbt = new CompoundNBT();
                nbt.func_74768_a("color", DanmakuColor.PINK.ordinal());
                HeartShotEntity heartShotPink = new HeartShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, nbt);
                shootVec = new Vector3d(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                vector3d = vector3d.func_178787_e(this.func_213303_ch());
                this.setDanmakuInit(heartShotPink, vector3d, new Vector2f((float)vector3d.field_72450_a, (float)vector3d.field_72448_b));
                heartShotPink.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, 0.55f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)heartShotPink);
            }
            for (Vector3d vector3d : aquaPositions) {
                nbt = new CompoundNBT();
                nbt.func_74768_a("color", DanmakuColor.AQUA.ordinal());
                HeartShotEntity heartShotAqua = new HeartShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, nbt);
                shootVec = new Vector3d(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                vector3d = vector3d.func_178787_e(this.func_213303_ch());
                this.setDanmakuInit(heartShotAqua, vector3d, new Vector2f((float)vector3d.field_72450_a, (float)vector3d.field_72448_b));
                heartShotAqua.func_70186_c(-shootVec.field_72450_a, -shootVec.field_72448_b, -shootVec.field_72449_c, 0.3f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)heartShotAqua);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }
}

