/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.SmallShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MobiusRingEntity
extends SpellCardEntity {
    public MobiusRingEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public MobiusRingEntity(World worldIn, PlayerEntity player) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.MOBIUS_RING_WORLD_ENTITY.get()), worldIn, player);
    }

    @Override
    public void func_70071_h_() {
        Vector3d horizonVec = new Vector3d(Vector3f.field_229183_f_);
        horizonVec = horizonVec.func_186678_a(6.0);
        Vector3d verticalVec = new Vector3d(Vector3f.field_229183_f_);
        verticalVec = verticalVec.func_186678_a(3.0);
        float velocity = 0.2f;
        float rotation = (float)(0.07853981633974483 * (double)this.field_70173_aa);
        horizonVec = horizonVec.func_178785_b(rotation);
        List<DanmakuColor> colors = DanmakuUtil.getRainbowColoredDanmaku();
        for (int i = 0; i < colors.size(); ++i) {
            SmallShotEntity smallShot = new SmallShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, DanmakuType.SMALL_SHOT, colors.get(i));
            verticalVec = verticalVec.func_178789_a((float)Math.PI / (float)colors.size() * (float)i);
            verticalVec = verticalVec.func_178785_b(0.07853982f * (float)this.field_70173_aa);
            this.setDanmakuInit(smallShot, horizonVec.func_178787_e(this.func_213303_ch()));
            smallShot.func_70186_c((float)verticalVec.func_82615_a(), (float)verticalVec.func_82617_b(), (float)verticalVec.func_82616_c(), velocity, 0.0f);
            this.field_70170_p.func_217376_c((Entity)smallShot);
        }
        int lifeSpan = 1000;
        if (this.field_70173_aa >= lifeSpan) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ItemRegistry.SC_MOBIUS_RING_WORLD.get());
    }
}

