/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.CircleShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class RorschachDanmakuEntity
extends SpellCardEntity {
    public RorschachDanmakuEntity(World worldIn, LivingEntity living) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.RORSCHACH_DANMAKU_ENTITY.get()), worldIn, living);
        this.lifeSpan = 1000;
        this.field_70180_af.func_187227_b(DATA_LIFESPAN, (Object)1000);
    }

    public RorschachDanmakuEntity(EntityType<RorschachDanmakuEntity> type, World world) {
        super(type, world);
        this.lifeSpan = 1000;
        this.field_70180_af.func_187227_b(DATA_LIFESPAN, (Object)1000);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vector2f vector2f = Vector2f.field_189974_a;
        Vector3d initPos = this.func_213303_ch();
        for (int i = 0; i < 4; ++i) {
            List<Vector3d> bluePos1 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> bluePos2 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> greenPos1 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> greenPos2 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> magentaPos1 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> magentaPos2 = DanmakuUtil.ellipticPos(vector2f, 3 * i, 60);
            List<Vector3d> blueShootPos1 = this.deepCopy(bluePos1);
            List<Vector3d> blueShootPos2 = this.deepCopy(bluePos2);
            List<Vector3d> greenShootPos1 = this.deepCopy(greenPos1);
            List<Vector3d> greenShootPos2 = this.deepCopy(greenPos2);
            List<Vector3d> magentaShootPos1 = this.deepCopy(magentaPos1);
            List<Vector3d> magentaShootPos2 = this.deepCopy(magentaPos2);
            bluePos1.replaceAll(vector3d -> initPos.func_178787_e(vector3d.func_178789_a(0.7853982f)));
            bluePos2.replaceAll(vector3d -> initPos.func_178787_e(vector3d.func_178789_a(-0.7853982f)));
            greenPos1.replaceAll(vector3d -> initPos.func_178787_e(vector3d.func_178789_a(0.31415927f)));
            greenPos2.replaceAll(vector3d -> initPos.func_178787_e(vector3d.func_178789_a(-0.31415927f)));
            magentaPos2.replaceAll(vector3d -> initPos.func_178787_e(vector3d.func_178789_a(1.5707964f)));
            float blueAngle1 = (float)(i % 2 == 0 ? 0.7853981633974483 : -0.7853981633974483);
            float blueAngle2 = (float)(i % 2 == 0 ? -0.7853981633974483 : 0.7853981633974483);
            float greenAngle1 = (float)(i % 2 == 0 ? 0.3141592653589793 : -0.3141592653589793);
            float greenAngle2 = (float)(i % 2 == 0 ? -0.3141592653589793 : 0.3141592653589793);
            float magentaAngle1 = (float)(i % 2 == 0 ? Math.PI : -1.5707963267948966);
            float magentaAngle2 = (float)(i % 2 == 0 ? 1.5707963267948966 : Math.PI);
            blueShootPos1.replaceAll(vector3d -> vector3d.func_178789_a(blueAngle1));
            blueShootPos2.replaceAll(vector3d -> vector3d.func_178789_a(blueAngle2));
            greenShootPos1.replaceAll(vector3d -> vector3d.func_178789_a(greenAngle1));
            greenShootPos2.replaceAll(vector3d -> vector3d.func_178789_a(greenAngle2));
            magentaShootPos1.replaceAll(vector3d -> vector3d.func_178789_a(magentaAngle1));
            magentaShootPos2.replaceAll(vector3d -> vector3d.func_178789_a(magentaAngle2));
            CompoundNBT scriptBlue = new CompoundNBT();
            scriptBlue.func_74768_a("color", DanmakuColor.BLUE.ordinal());
            CompoundNBT scriptGreen = new CompoundNBT();
            scriptGreen.func_74768_a("color", DanmakuColor.GREEN.ordinal());
            CompoundNBT scriptMagenta = new CompoundNBT();
            scriptMagenta.func_74768_a("color", DanmakuColor.MAGENTA.ordinal());
            CompoundNBT scriptBlueCounter = new CompoundNBT();
            scriptBlue.func_74768_a("color", DanmakuColor.BLUE.ordinal());
            CompoundNBT scriptGreenCounter = new CompoundNBT();
            scriptGreen.func_74768_a("color", DanmakuColor.GREEN.ordinal());
            CompoundNBT scriptMagentaCounter = new CompoundNBT();
            scriptGreen.func_74768_a("color", DanmakuColor.MAGENTA.ordinal());
            int interval = 2;
            if (this.field_70173_aa % interval != 0) continue;
            int index = this.field_70173_aa / interval % bluePos1.size();
            this.applyScript(bluePos1.get(index), blueShootPos1.get(index), scriptBlue);
            this.applyScript(bluePos2.get(index), blueShootPos2.get(index), scriptBlueCounter);
            this.applyScript(greenPos1.get(index), greenShootPos1.get(index), scriptGreen);
            this.applyScript(greenPos2.get(index), greenShootPos2.get(index), scriptGreenCounter);
            this.applyScript(magentaPos1.get(index), magentaShootPos1.get(index), scriptMagenta);
            this.applyScript(magentaPos2.get(index), magentaShootPos2.get(index), scriptMagentaCounter);
        }
    }

    private List<Vector3d> deepCopy(List<Vector3d> prevVec) {
        ArrayList<Vector3d> list = new ArrayList<Vector3d>();
        prevVec.forEach(vec -> list.add(new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
        return list;
    }

    private void applyScript(CompoundNBT script, Vector3d initPos, String funcName, List<Object> params) {
        ListNBT list = new ListNBT();
        CompoundNBT behavior = new CompoundNBT();
        behavior.func_74768_a("keyTick", 100);
        behavior.func_218657_a(funcName, (INBT)params);
        list.add((Object)behavior);
        script.func_218657_a("behaviors", (INBT)list);
        script.func_74778_a("type", "keyTickBehavior");
        CircleShotEntity danmaku = new CircleShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, script);
        this.setDanmakuInit(danmaku, initPos);
        this.field_70170_p.func_217376_c((Entity)danmaku);
    }

    private void applyScript(Vector3d initPos, Vector3d vector3d, CompoundNBT script) {
        ListNBT list = new ListNBT();
        ListNBT motion = new ListNBT();
        motion.add((Object)DoubleNBT.func_229684_a_((double)vector3d.field_72450_a));
        motion.add((Object)DoubleNBT.func_229684_a_((double)vector3d.field_72448_b));
        motion.add((Object)DoubleNBT.func_229684_a_((double)vector3d.field_72449_c));
        CompoundNBT behavior = new CompoundNBT();
        behavior.func_74768_a("keyTick", 100);
        behavior.func_218657_a("setMotion", (INBT)motion);
        list.add((Object)behavior);
        script.func_218657_a("behaviors", (INBT)list);
        script.func_74778_a("type", "keyTickBehavior");
        CircleShotEntity danmaku = new CircleShotEntity((LivingEntity)this.getOwner(), this.field_70170_p, script);
        this.setDanmakuInit(danmaku, initPos);
        this.field_70170_p.func_217376_c((Entity)danmaku);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }
}

