/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.FakeLunarEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.LargeShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.LargeStarShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.RiceShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.ScaleShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.SmallShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.SmallStarShotEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.TalismanShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.SpellCardEntity;
import github.thelawf.gensokyoontology.common.nbt.script.StaticFunc;
import github.thelawf.gensokyoontology.common.nbt.script.V3dFunc;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ScriptedSpellCardEntity
extends SpellCardEntity {
    private CompoundNBT scriptsNBT = new CompoundNBT();
    public static final DataParameter<CompoundNBT> DATA_SCRIPT = EntityDataManager.func_187226_a(ScriptedSpellCardEntity.class, (IDataSerializer)DataSerializers.field_192734_n);

    public ScriptedSpellCardEntity(World worldIn, LivingEntity living, CompoundNBT scriptsNBT) {
        super((EntityType<? extends SpellCardEntity>)((EntityType)EntityRegistry.SCRIPTED_SPELL_CARD_ENTITY.get()), worldIn, living);
        this.func_70012_b(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), living.field_70177_z, living.field_70125_A);
        this.setScript(scriptsNBT);
    }

    public ScriptedSpellCardEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_70012_b(0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SCRIPT, (Object)this.scriptsNBT);
    }

    @Override
    protected void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.scriptsNBT = compound.func_74775_l("script");
        this.field_70180_af.func_187227_b(DATA_SCRIPT, (Object)this.scriptsNBT);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("script", (INBT)this.scriptsNBT);
    }

    public CompoundNBT getScript() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(DATA_SCRIPT);
    }

    public void setScript(CompoundNBT scriptNBT) {
        this.scriptsNBT = scriptNBT;
        this.field_70180_af.func_187227_b(DATA_SCRIPT, (Object)scriptNBT);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.onScriptTick(this.field_70170_p, this.getOwner(), this.field_70173_aa);
    }

    @Override
    public void onScriptTick(World world, Entity owner, int ticksIn) {
        super.onScriptTick(world, owner, ticksIn);
        this.runScript();
    }

    @Override
    @NotNull
    public ItemStack func_184543_l() {
        return ItemStack.field_190927_a;
    }

    private void runScript() {
        if (!(this.getOwner() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)this.getOwner();
        ListNBT listNBT = this.getListOrSendFeedback(this.getScript(), player);
        if (!this.canExecute(player)) {
            return;
        }
        for (INBT inbt : listNBT) {
            if (!(inbt instanceof CompoundNBT)) {
                this.sendTypeExceptionFeedback(player, "type_of_each_script_in_list_not_allowed");
                return;
            }
            this.runEachScript(this.castToCompound(inbt), player);
        }
    }

    private void runEachScript(CompoundNBT scriptNBT, PlayerEntity player) {
        if (scriptNBT.func_74779_i("methodName").equals(StaticFunc.SHOOT.methodName)) {
            this.runShootFunc(scriptNBT, player);
        }
    }

    private void runShootFunc(CompoundNBT shootEntry, PlayerEntity player) {
        ListNBT parameters = this.getListOrSendFeedback(shootEntry, "parameters", player);
        ArrayList<CompoundNBT> params = new ArrayList<CompoundNBT>();
        if (this.strictMatches(parameters, StaticFunc.SHOOT, player)) {
            for (INBT inbt : parameters) {
                params.add(this.castToCompound(inbt));
                ((CompoundNBT)params.get(0)).func_74779_i("danmakuType");
            }
            AbstractDanmakuEntity danmaku = this.createDanmakuIf((CompoundNBT)params.get(0), player);
            Vector3d shootVec = new Vector3d(((CompoundNBT)params.get(1)).func_74775_l("value").func_74769_h("x"), ((CompoundNBT)params.get(1)).func_74775_l("value").func_74769_h("y"), ((CompoundNBT)params.get(1)).func_74775_l("value").func_74769_h("z"));
            shootVec = shootVec.func_72432_b();
            this.setDanmakuInit(danmaku, this.func_213303_ch());
            danmaku.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, ((CompoundNBT)params.get(2)).func_74760_g("value"), ((CompoundNBT)params.get(3)).func_74760_g("value"));
            this.field_70170_p.func_217376_c((Entity)danmaku);
        }
    }

    private AbstractDanmakuEntity createDanmakuIf(CompoundNBT danmakuData, PlayerEntity player) {
        AtomicReference danmakuTypeAtom = new AtomicReference();
        AtomicReference danmakuColorAtom = new AtomicReference();
        Arrays.stream(DanmakuType.values()).forEach(dt -> danmakuTypeAtom.set(dt.getIfMatches(danmakuData.func_74779_i("danmakuType"))));
        Arrays.stream(DanmakuColor.values()).forEach(dc -> danmakuColorAtom.set(dc.getIfMatches(danmakuData.func_74779_i("danmakuColor"))));
        return this.createDanmakuInstance((DanmakuType)((Object)danmakuTypeAtom.get()), (DanmakuColor)((Object)danmakuColorAtom.get()), player);
    }

    private AbstractDanmakuEntity createDanmakuInstance(DanmakuType danmakuType, DanmakuColor danmakuColor, PlayerEntity player) {
        switch (danmakuType) {
            default: {
                return new LargeShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case SMALL_SHOT: {
                return new SmallShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case RICE_SHOT: {
                return new RiceShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case SCALE_SHOT: {
                return new ScaleShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case TALISMAN_SHOT: {
                return new TalismanShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case STAR_SHOT_SMALL: {
                return new SmallStarShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case STAR_SHOT_LARGE: {
                return new LargeStarShotEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
            }
            case FAKE_LUNAR: 
        }
        return new FakeLunarEntity((LivingEntity)player, player.field_70170_p, danmakuType, danmakuColor);
    }

    private boolean strictMatches(INBT inbt, String type) {
        return this.castToCompound(inbt).func_74779_i("type").equals(type);
    }

    private boolean strictMatches(ListNBT listNBT, StaticFunc staticFunc, PlayerEntity player) {
        if (listNBT.size() != staticFunc.parameters.size()) {
            this.sendNullPointerFeedback(player, "not_provide_enough_parameters");
            return false;
        }
        List typeList = listNBT.stream().map(inbt -> {
            if (inbt instanceof CompoundNBT) {
                CompoundNBT nbt = (CompoundNBT)inbt;
                return nbt.func_74779_i("type");
            }
            return "";
        }).collect(Collectors.toList());
        for (StaticFunc func : StaticFunc.values()) {
            if (!typeList.stream().sorted().collect(Collectors.joining()).equals(func.parameters.stream().sorted().collect(Collectors.joining()))) continue;
            return true;
        }
        return false;
    }

    private boolean strictMatches(ListNBT listNBT, V3dFunc v3dFunc, PlayerEntity player) {
        if (listNBT.size() != v3dFunc.paramTypes.size()) {
            this.sendNullPointerFeedback(player, "not_provide_enough_parameters");
            return false;
        }
        return listNBT.stream().allMatch(inbt -> {
            boolean flag = false;
            for (String type : v3dFunc.paramTypes) {
                flag = this.castToCompound((INBT)inbt).func_74779_i("type").equals(type);
            }
            return flag;
        });
    }

    public CompoundNBT castToCompound(INBT inbt) {
        return inbt instanceof CompoundNBT ? (CompoundNBT)inbt : new CompoundNBT();
    }

    private ListNBT getListOrSendFeedback(CompoundNBT nbtIn, PlayerEntity player) {
        ListNBT listNBT;
        if (!(nbtIn.func_74781_a("scripts") instanceof ListNBT)) {
            this.sendTypeExceptionFeedback(player, "acquired_data_not_a_list");
        }
        if ((listNBT = (ListNBT)nbtIn.func_74781_a("scripts")) == null) {
            this.sendNullPointerFeedback(player, "list_is_null");
        }
        return listNBT;
    }

    private ListNBT getListOrSendFeedback(CompoundNBT nbtIn, String listKey, PlayerEntity player) {
        ListNBT listNBT;
        if (!(nbtIn.func_74781_a(listKey) instanceof ListNBT)) {
            this.sendTypeExceptionFeedback(player, "acquired_data_not_a_list");
        }
        if ((listNBT = (ListNBT)nbtIn.func_74781_a(listKey)) == null) {
            this.sendNullPointerFeedback(player, "list_is_null");
        }
        return listNBT;
    }

    private boolean canExecute(PlayerEntity player) {
        return this.getScript().func_74781_a("scripts") instanceof ListNBT;
    }

    private boolean canExecute(CompoundNBT nbtIn, String listKey, PlayerEntity player) {
        ListNBT listNBT;
        if (!(nbtIn.func_74781_a(listKey) instanceof ListNBT)) {
            this.sendTypeExceptionFeedback(player, "acquired_data_not_a_list");
        }
        if ((listNBT = (ListNBT)nbtIn.func_74781_a(listKey)) == null) {
            this.sendNullPointerFeedback(player, "list_is_null");
        }
        return nbtIn.func_74781_a(listKey) instanceof ListNBT || listNBT != null;
    }

    private void sendTypeExceptionFeedback(PlayerEntity player, String msg) {
        if (this.field_70173_aa == 2) {
            player.func_145747_a((ITextComponent)GensokyoOntology.withTranslation("script.", ".error.type_exception." + msg), player.func_110124_au());
        }
    }

    private void sendNullPointerFeedback(PlayerEntity player, String msg) {
        if (this.field_70173_aa == 2) {
            player.func_145747_a((ITextComponent)GensokyoOntology.withTranslation("script.", ".error.null_pointer_exception." + msg), player.func_110124_au());
        }
    }

    @Deprecated
    private void onScriptTickOld() {
    }
}

