/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard;

import github.thelawf.gensokyoontology.common.entity.projectile.AbstractDanmakuEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuColor;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuPool;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public abstract class SpellCardEntity
extends Entity
implements IRendersAsItem {
    protected int lifeSpan = 500;
    protected UUID owner;
    private int ownerId;
    protected Vector3d shootAngle = new Vector3d(Vector3f.field_229179_b_);
    public static final DataParameter<Integer> DATA_LIFESPAN = EntityDataManager.func_187226_a(SpellCardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Optional<UUID>> DATA_OWNER_UUID = EntityDataManager.func_187226_a(SpellCardEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public SpellCardEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn, LivingEntity living) {
        this(entityTypeIn, worldIn);
        this.func_70012_b(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), living.field_70177_z, living.field_70125_A);
        this.setOwner((Entity)living);
    }

    public SpellCardEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn, PlayerEntity player) {
        this(entityTypeIn, worldIn);
        this.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        this.setOwner((Entity)worldIn.func_217371_b(player.func_110124_au()));
    }

    public SpellCardEntity(EntityType<? extends SpellCardEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_LIFESPAN, (Object)this.lifeSpan);
        this.field_70180_af.func_187214_a(DATA_OWNER_UUID, Optional.empty());
    }

    protected void func_70037_a(@NotNull CompoundNBT compound) {
        if (compound.func_74764_b("Lifespan")) {
            this.lifeSpan = compound.func_74762_e("Lifespan");
        }
        UUID uuid = null;
        if (compound.func_186855_b("Owner")) {
            uuid = compound.func_186857_a("Owner");
        }
        if (uuid != null) {
            this.setOwnerId(uuid);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Lifespan", this.lifeSpan);
        if (this.owner != null) {
            compound.func_186854_a("Owner", this.owner);
        }
    }

    public boolean hasOwner() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_OWNER_UUID)).isPresent();
    }

    public void setOwner(@Nullable Entity entityIn) {
        if (entityIn != null) {
            this.owner = entityIn.func_110124_au();
            this.setOwnerId(this.owner);
        }
    }

    private void setOwnerId(UUID uuid) {
        this.field_70180_af.func_187227_b(DATA_OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public Entity getOwner() {
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            Optional optionalUUID = (Optional)this.func_184212_Q().func_187225_a(DATA_OWNER_UUID);
            if (optionalUUID.isPresent()) {
                return serverWorld.func_217461_a((UUID)optionalUUID.get());
            }
        }
        return null;
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_OWNER_UUID)).orElse(null);
    }

    public int getLifeSpan() {
        return this.lifeSpan;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!((Optional)this.field_70180_af.func_187225_a(DATA_OWNER_UUID)).isPresent()) {
            this.func_70106_y();
        }
        if (this.field_70173_aa >= this.lifeSpan) {
            this.func_70106_y();
        }
    }

    protected <D extends AbstractDanmakuEntity> void initDanmaku(D danmaku) {
        danmaku.func_189654_d(true);
        danmaku.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
    }

    protected <D extends AbstractDanmakuEntity> void setDanmakuInit(D danmaku, Vector3d initPosition) {
        danmaku.func_189654_d(true);
        danmaku.func_70012_b(initPosition.field_72450_a, initPosition.field_72448_b, initPosition.field_72449_c, this.field_70177_z, this.field_70125_A);
    }

    protected <D extends AbstractDanmakuEntity> void setDanmakuInit(D danmaku, Vector3d initPosition, Vector2f initRotation) {
        danmaku.func_189654_d(true);
        danmaku.func_70012_b(initPosition.field_72450_a, initPosition.field_72448_b, initPosition.field_72449_c, initRotation.field_189982_i, initRotation.field_189983_j);
    }

    protected <D extends AbstractDanmakuEntity> void setDanmakuInit(D danmaku, Vector3d initPosition, double rotationYaw, double rotationPitch) {
        this.setDanmakuInit(danmaku, initPosition, new Vector2f((float)rotationYaw, (float)rotationPitch));
    }

    protected <D extends AbstractDanmakuEntity> void setDanmakuInit(D danmaku, Vector3d initPosition, float rotationYaw, float rotationPitch, boolean noGravity) {
        danmaku.func_189654_d(noGravity);
        this.setDanmakuInit(danmaku, initPosition, new Vector2f(rotationYaw, rotationPitch));
    }

    protected <D extends AbstractDanmakuEntity> void setDanmakuInit(D danmaku, Vector3d initPosition, Vector2f initRotation, boolean noGravity) {
        danmaku.func_189654_d(noGravity);
        this.setDanmakuInit(danmaku, initPosition, initRotation);
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onTick(World world, Entity entity, int ticksIn) {
    }

    public void onScriptTick(World world, Entity owner, int ticksIn) {
    }

    protected <D extends AbstractDanmakuEntity> List<D> newDanmakuList(Supplier<D> danmaku, Class<D> danmakuClass, int count) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ArrayList<AbstractDanmakuEntity> danmakuPool = new ArrayList<AbstractDanmakuEntity>();
        for (int i = 0; i < count; ++i) {
            danmakuPool.add(this.newDanmaku((AbstractDanmakuEntity)((Object)danmaku.get()), danmakuClass));
        }
        return danmakuPool;
    }

    protected <D extends AbstractDanmakuEntity> Map<Integer, D> newDanmakuMap(D danmaku, Class<D> danmakuClass, int count) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<Integer, AbstractDanmakuEntity> danmakuMap = new HashMap<Integer, AbstractDanmakuEntity>();
        for (int i = 0; i < count; ++i) {
            Constructor<D> constructor = danmakuClass.getDeclaredConstructor(LivingEntity.class, World.class, DanmakuType.class, DanmakuColor.class);
            AbstractDanmakuEntity instance = (AbstractDanmakuEntity)((Object)constructor.newInstance(new Object[]{danmaku.getShooter(), danmaku.field_70170_p, danmaku.getDanmakuType(), danmaku.getDanmakuColor()}));
            danmakuMap.put(instance.func_145782_y(), instance);
        }
        return danmakuMap;
    }

    protected <D extends AbstractDanmakuEntity> D newDanmaku(D danmaku, Class<D> danmakuClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<D> constructor = danmakuClass.getDeclaredConstructor(LivingEntity.class, World.class, DanmakuType.class, DanmakuColor.class);
        return (D)((Object)((AbstractDanmakuEntity)((Object)constructor.newInstance(new Object[]{danmaku.getShooter(), danmaku.field_70170_p, danmaku.getDanmakuType(), danmaku.getDanmakuColor()}))));
    }

    protected <D extends AbstractDanmakuEntity> DanmakuPool<D> newDanmakuPool(D danmaku, Class<D> danmakuClass, int count) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        DanmakuPool danmakuPool = new DanmakuPool();
        for (int i = 0; i < count; ++i) {
            Constructor<D> constructor = danmakuClass.getDeclaredConstructor(LivingEntity.class, World.class, DanmakuType.class, DanmakuColor.class);
            danmakuPool.add(constructor.newInstance(new Object[]{danmaku.getShooter(), danmaku.field_70170_p, danmaku.getDanmakuType(), danmaku.getDanmakuColor()}));
        }
        return danmakuPool;
    }

    public <D extends AbstractDanmakuEntity> D acquire(Deque<D> deque, Vector3d positionVec, Vector2f rotationVec) {
        AbstractDanmakuEntity entity = (AbstractDanmakuEntity)((Object)deque.pollFirst());
        if (entity != null) {
            entity.func_189654_d(true);
            entity.func_70012_b(positionVec.field_72450_a, positionVec.field_72448_b, positionVec.field_72449_c, rotationVec.field_189982_i, rotationVec.field_189983_j);
            return (D)((Object)entity);
        }
        return null;
    }

    protected CompoundNBT initColor(DanmakuColor colorIn) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("color", colorIn.ordinal());
        return nbt;
    }

    protected Vector2f lookVecToDegrees(Vector3d vector3d) {
        float f1 = (float)Math.acos(vector3d.field_72448_b);
        float f2 = (float)Math.atan2(vector3d.field_72449_c, vector3d.field_72450_a);
        return new Vector2f(f1, f2);
    }

    @NotNull
    public abstract ItemStack func_184543_l();
}

