/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard.boss;

import github.thelawf.gensokyoontology.common.entity.misc.LaserSourceEntity;
import github.thelawf.gensokyoontology.common.entity.monster.FlandreScarletEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.LargeShotEntity;
import github.thelawf.gensokyoontology.common.entity.spellcard.boss.BossSpell;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class FlandreSpellAttack {
    public final BossSpell bossSpell;
    public World world;
    public FlandreScarletEntity flandre;

    public FlandreSpellAttack(World world, FlandreScarletEntity flandre) {
        this.world = world;
        this.flandre = flandre;
        this.bossSpell = BossSpell.of(this::sphereDanmaku, this::laserAttack);
    }

    private void sphereDanmaku() {
        this.sphereShot(10);
    }

    private void laserAttack() {
        if (this.flandre.func_70638_az() == null) {
            return;
        }
        if (this.flandre.field_70173_aa % 50 == 0) {
            LaserSourceEntity laser = new LaserSourceEntity(this.world, (Entity)this.flandre);
            laser.func_70012_b(this.flandre.func_226277_ct_(), this.flandre.func_226278_cu_(), this.flandre.func_226281_cx_(), this.flandre.getAimedYaw(), this.flandre.getAimedPitch());
            laser.setOwnerId(this.flandre.func_110124_au());
            this.world.func_217376_c((Entity)laser);
        }
    }

    private void sphereShot(int count) {
        List<Vector3d> shootVec = DanmakuUtil.spheroidPos(1.0, count);
        shootVec.forEach(vector3d -> {
            Vector3d vec = GSKOMathUtil.randomVec(-3.0, 3.0);
            LargeShotEntity largeShot = new LargeShotEntity(this.world);
            DanmakuUtil.initDanmaku(largeShot, this.flandre.func_213303_ch().func_72441_c(vector3d.field_72450_a, 1.2, vector3d.field_72449_c).func_72441_c(vec.field_72450_a, 0.0, vec.field_72449_c), true);
            largeShot.func_70186_c(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.7f, 0.0f);
            largeShot.func_212361_a((Entity)this.flandre);
            this.world.func_217376_c((Entity)largeShot);
        });
    }

    public static void laser(FlandreScarletEntity flandre) {
        if (flandre.func_70638_az() == null) {
            return;
        }
        if (flandre.field_70173_aa % 50 == 0) {
            LaserSourceEntity laser = new LaserSourceEntity(flandre.field_70170_p, (Entity)flandre);
            laser.func_70012_b(flandre.func_226277_ct_(), flandre.func_226278_cu_(), flandre.func_226281_cx_(), flandre.getAimedYaw(), flandre.getAimedPitch());
            laser.setOwnerId(flandre.func_110124_au());
            flandre.field_70170_p.func_217376_c((Entity)laser);
        }
    }

    public static void sphere(FlandreScarletEntity flandre) {
        List<Vector3d> shootVec = DanmakuUtil.spheroidPos(1.0, 10);
        World world = flandre.field_70170_p;
        shootVec.forEach(vector3d -> {
            Vector3d vec = GSKOMathUtil.randomVec(-3.0, 3.0);
            LargeShotEntity largeShot = new LargeShotEntity(world);
            DanmakuUtil.initDanmaku(largeShot, flandre.func_213303_ch().func_72441_c(vector3d.field_72450_a, 1.2, vector3d.field_72449_c).func_72441_c(vec.field_72450_a, 0.0, vec.field_72449_c), true);
            largeShot.func_70186_c(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.7f, 0.0f);
            largeShot.func_212361_a((Entity)flandre);
            world.func_217376_c((Entity)largeShot);
        });
    }
}

