/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.entity.spellcard.boss;

import com.google.common.collect.ImmutableList;
import github.thelawf.gensokyoontology.common.entity.misc.LaserSourceEntity;
import github.thelawf.gensokyoontology.common.entity.monster.RemiliaScarletEntity;
import github.thelawf.gensokyoontology.common.entity.projectile.LargeShotEntity;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RemiliaSpellAttack {
    public static List<Runnable> toSpells(World world, RemiliaScarletEntity remilia) {
        return ImmutableList.of(() -> RemiliaSpellAttack.sphere(world, remilia));
    }

    public static void sphere(World world, RemiliaScarletEntity remilia) {
        List<Vector3d> shootVec = DanmakuUtil.spheroidPos(1.0, 20);
        shootVec.forEach(vector3d -> {
            Vector3d vec = GSKOMathUtil.randomVec(-3.0, 3.0);
            LargeShotEntity largeShot = new LargeShotEntity(world);
            DanmakuUtil.initDanmaku(largeShot, remilia.func_213303_ch().func_72441_c(vector3d.field_72450_a, 1.2, vector3d.field_72449_c).func_72441_c(vec.field_72450_a, 0.0, vec.field_72449_c), true);
            largeShot.func_70186_c(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0.7f, 0.0f);
            largeShot.func_212361_a((Entity)remilia);
            world.func_217376_c((Entity)largeShot);
        });
    }

    public static void tickLaserSpiral(RemiliaScarletEntity remilia) {
        int count = 25;
        Vector3d initRot = new Vector3d(1.0, 0.0, 0.0);
        Vector3d position = remilia.func_213303_ch();
        for (int i = remilia.field_70173_aa; i < remilia.field_70173_aa + count; ++i) {
            int unit = i - remilia.field_70173_aa;
            initRot = initRot.func_178785_b((float)Math.PI / (float)count);
            position = position.func_178787_e(new Vector3d(0.0, 0.5, 0.0));
            Vector2f direction = GSKOMathUtil.toYawPitch(initRot);
            LaserSourceEntity laser = new LaserSourceEntity(remilia.field_70170_p, (Entity)remilia);
            laser.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, direction.field_189982_i, direction.field_189983_j);
            laser.init(500, 30, 100.0f);
            remilia.field_70170_p.func_217376_c((Entity)laser);
        }
    }
}

