/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.events;

import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncCapabilityMessage;
import com.mojang.datafixers.util.Pair;
import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.entity.BeliefCapability;
import github.thelawf.gensokyoontology.common.capability.entity.BeliefCapabilityProvider;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerCapability;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerProvider;
import github.thelawf.gensokyoontology.common.capability.entity.SecularLifetimeProvider;
import github.thelawf.gensokyoontology.common.capability.world.BloodyMistProvider;
import github.thelawf.gensokyoontology.common.capability.world.EternalSummerCapProvider;
import github.thelawf.gensokyoontology.common.capability.world.IIncidentCapability;
import github.thelawf.gensokyoontology.common.capability.world.ImperishableNightProvider;
import github.thelawf.gensokyoontology.common.item.touhou.SeigaHairpin;
import github.thelawf.gensokyoontology.common.network.GSKONetworking;
import github.thelawf.gensokyoontology.common.network.packet.CPowerChangedPacket;
import github.thelawf.gensokyoontology.common.network.packet.SLifeTickPacket;
import github.thelawf.gensokyoontology.common.util.BeliefType;
import github.thelawf.gensokyoontology.common.util.GSKOUtil;
import github.thelawf.gensokyoontology.common.world.GSKODimensions;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="gensokyoontology")
public class GSKOCapabilityEvents {
    @SubscribeEvent
    public static void onCapabilityAttachToWorld(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof World) {
            ArrayList<String> biomes = new ArrayList<String>();
            biomes.add("gensokyoontology:scarlet_mansion_precincts");
            biomes.add("gensokyoontology:misty_lake");
            BloodyMistProvider bloodyMist = new BloodyMistProvider(biomes, true);
            ImperishableNightProvider imperishableNight = new ImperishableNightProvider(18000, false);
            EternalSummerCapProvider eternalSummer = new EternalSummerCapProvider(true);
            event.addCapability(GensokyoOntology.withRL("bloody_mist"), (ICapabilityProvider)bloodyMist);
            event.addCapability(GensokyoOntology.withRL("imperishable_night"), (ICapabilityProvider)imperishableNight);
            event.addCapability(GensokyoOntology.withRL("eternal_summer"), (ICapabilityProvider)eternalSummer);
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttachToEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            ArrayList<Pair<BeliefType, Integer>> set = new ArrayList<Pair<BeliefType, Integer>>();
            for (BeliefType type : BeliefType.values()) {
                set.add((Pair<BeliefType, Integer>)Pair.of((Object)((Object)type), (Object)1));
            }
            GSKOPowerProvider power = new GSKOPowerProvider(0.0f);
            BeliefCapabilityProvider belief = new BeliefCapabilityProvider(set);
            SecularLifetimeProvider lifetime = new SecularLifetimeProvider(0L);
            event.addCapability(GensokyoOntology.withRL("power"), (ICapabilityProvider)power);
            event.addCapability(GensokyoOntology.withRL("belief"), (ICapabilityProvider)belief);
            event.addCapability(GensokyoOntology.withRL("secular_lifetime"), (ICapabilityProvider)lifetime);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        GSKOCapabilityEvents.updateBelief(event);
        GSKOCapabilityEvents.updatePower(event);
        GSKOCapabilityEvents.updateLife(event);
    }

    @SubscribeEvent
    public static void onWorldTickDuringIncident(WorldEvent.Load event) {
        ServerWorld serverWorld;
        if (event.getWorld() instanceof ServerWorld && (serverWorld = ((ServerWorld)event.getWorld()).func_73046_m().func_71218_a(GSKODimensions.GENSOKYO)) != null) {
            GSKOCapabilityEvents.updateCapability(serverWorld, GSKOCapabilities.BLOODY_MIST);
            GSKOCapabilityEvents.updateCapability(serverWorld, GSKOCapabilities.IMPERISHABLE_NIGHT);
        }
    }

    @SubscribeEvent
    public static void onPacketSync(TickEvent.PlayerTickEvent event) {
        boolean flag;
        PlayerEntity player = event.player;
        boolean bl = flag = event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END;
        if (GSKOUtil.firstMatch(player, (Item)ItemRegistry.SEIGA_HAIRPIN.get())) {
            SeigaHairpin.trySetNoClip(player, GSKOUtil.findItem(player, (Item)ItemRegistry.SEIGA_HAIRPIN.get()));
        }
    }

    public static void trySyncLifetime(PlayerEntity player) {
        player.getCapability(GSKOCapabilities.SECULAR_LIFE).ifPresent(cap -> {
            cap.addTime(1L);
            GSKONetworking.sendToClientPlayer(new SLifeTickPacket(cap.getLifetime()), player);
        });
    }

    public static void trySyncPower(PlayerEntity player) {
        player.getCapability(GSKOCapabilities.POWER).ifPresent(cap -> {
            GSKONetworking.sendToClientPlayer(new CPowerChangedPacket(cap.getCount()), player);
            cap.markDirty();
        });
    }

    public static void trySyncPowerToTLM(PlayerEntity player) {
        player.getCapability(GSKOCapabilities.POWER).ifPresent(gskoCap -> player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(tlmCap -> player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).ifPresent(maidNumCap -> {
            tlmCap.set(gskoCap.getCount());
            NetworkHandler.sendToClientPlayer((Object)new SyncCapabilityMessage(gskoCap.getCount(), maidNumCap.get()), (PlayerEntity)player);
            tlmCap.setDirty(false);
        })));
    }

    public static void trySyncPowerFromTLM(PlayerEntity player) {
        player.getCapability(GSKOCapabilities.POWER).ifPresent(gskoCap -> player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(tlmCap -> {
            gskoCap.setCount(tlmCap.get());
            GSKONetworking.sendToClientPlayer(new CPowerChangedPacket(tlmCap.get()), player);
            tlmCap.setDirty(false);
        }));
    }

    public static void onPacketSendToClient(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END) {
            player.getCapability(GSKOCapabilities.POWER).ifPresent(cap -> GSKONetworking.CHANNEL.sendToServer((Object)new GSKOPowerCapability(cap.getCount())));
            player.getCapability(GSKOCapabilities.POWER).ifPresent(cap -> GSKONetworking.sendToClientPlayer(new CPowerChangedPacket(cap.getCount()), player));
        }
    }

    private static void updatePower(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            LazyOptional oldCapability = event.getOriginal().getCapability(GSKOCapabilities.POWER);
            LazyOptional newCapability = event.getPlayer().getCapability(GSKOCapabilities.POWER);
            newCapability.ifPresent(capNew -> oldCapability.ifPresent(capOld -> capNew.deserializeNBT(GSKOPowerCapability.INSTANCE.serializeNBT())));
        }
    }

    private static void updateLife(PlayerEvent.Clone event) {
        PlayerEntity playerOld = event.getOriginal();
        PlayerEntity playerNew = event.getPlayer();
        LazyOptional oldCapability = playerOld.getCapability(GSKOCapabilities.SECULAR_LIFE);
        LazyOptional newCapability = playerNew.getCapability(GSKOCapabilities.SECULAR_LIFE);
        if (oldCapability.isPresent() && newCapability.isPresent()) {
            newCapability.ifPresent(capNew -> oldCapability.ifPresent(capOld -> {
                if (event.isWasDeath()) {
                    capNew.setLifetime(0L);
                } else {
                    capNew.setLifetime(capOld.getLifetime());
                }
            }));
        }
    }

    private static void updateBelief(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            LazyOptional oldCapability = event.getOriginal().getCapability(GSKOCapabilities.BELIEF);
            LazyOptional newCapability = event.getPlayer().getCapability(GSKOCapabilities.BELIEF);
            newCapability.ifPresent(capNew -> oldCapability.ifPresent(capOld -> capNew.deserializeNBT(BeliefCapability.INSTANCE.serializeNBT())));
        }
    }

    private static <C extends IIncidentCapability> void updateCapability(ServerWorld serverWorld, Capability<C> capability) {
        LazyOptional oldCapability = serverWorld.getCapability(capability);
        LazyOptional newCapability = serverWorld.getCapability(capability);
        if (oldCapability.isPresent() && newCapability.isPresent()) {
            newCapability.ifPresent(capNew -> oldCapability.ifPresent(capOld -> capNew.deserializeNBT(capOld.serializeNBT())));
        }
    }

    private static void updateCapability(ServerPlayerEntity serverPlayer) {
        GSKONetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new CPowerChangedPacket(3.0f));
    }
}

