/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.events;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.common.block.nature.HotSpringBlock;
import github.thelawf.gensokyoontology.common.capability.GSKOCapabilities;
import github.thelawf.gensokyoontology.common.capability.entity.BeliefCapability;
import github.thelawf.gensokyoontology.common.capability.entity.GSKOPowerCapability;
import github.thelawf.gensokyoontology.common.capability.entity.SecularLifeCapability;
import github.thelawf.gensokyoontology.common.entity.monster.FairyEntity;
import github.thelawf.gensokyoontology.common.network.GSKONetworking;
import github.thelawf.gensokyoontology.common.network.packet.CPowerChangedPacket;
import github.thelawf.gensokyoontology.common.potion.HypnosisEffect;
import github.thelawf.gensokyoontology.common.potion.LovePotionEffect;
import github.thelawf.gensokyoontology.common.util.GSKODamageSource;
import github.thelawf.gensokyoontology.common.util.danmaku.DanmakuUtil;
import github.thelawf.gensokyoontology.common.util.math.GSKOMathUtil;
import github.thelawf.gensokyoontology.common.util.world.GSKOWorldUtil;
import github.thelawf.gensokyoontology.common.world.GSKODimensions;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.core.GSKOSoundEvents;
import github.thelawf.gensokyoontology.core.init.BlockRegistry;
import github.thelawf.gensokyoontology.core.init.EffectRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gensokyoontology")
public class GSKOEntityEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            player.getCapability(GSKOCapabilities.POWER).ifPresent(gskoCap -> {
                GSKONetworking.sendToClientPlayer(new CPowerChangedPacket(gskoCap.getCount()), player);
                GSKOPowerCapability.INSTANCE = gskoCap;
            });
            player.getCapability(GSKOCapabilities.SECULAR_LIFE).ifPresent(SecularLifeCapability::markDirty);
            player.getCapability(GSKOCapabilities.BELIEF).ifPresent(belief -> {
                BeliefCapability.INSTANCE = belief;
            });
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public static void onHotSpringIn(LivingEvent.LivingUpdateEvent event) {
        BlockState blockState;
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70090_H() && (blockState = event.getEntityLiving().func_213339_cH()).getBlockState().func_177230_c() instanceof HotSpringBlock && !(event.getEntityLiving() instanceof IMob)) {
            event.getEntityLiving().func_70691_i(1.2f);
        }
    }

    @SubscribeEvent
    public static void onWineIn(LivingEvent.LivingUpdateEvent event) {
        BlockState blockState;
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70090_H() && (blockState = event.getEntityLiving().func_213339_cH()).getBlockState().func_177230_c().equals(BlockRegistry.SAKE_WINE_BLOCK.get()) && event.getEntityLiving() instanceof PlayerEntity) {
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76431_k, 200));
        }
    }

    @SubscribeEvent
    public static void onAdvancementDone(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof ServerPlayerEntity) {
            ResourceLocation location;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.player;
            PlayerAdvancements advancement = serverPlayer.func_192039_O();
            if (serverPlayer.field_70170_p.func_73046_m() == null) {
                return;
            }
            AdvancementManager manager = serverPlayer.field_70170_p.func_73046_m().func_191949_aK();
            if (manager.func_192778_a(location = new ResourceLocation("gensokyoontology", "gensokyo_traveller")) == null) {
                return;
            }
            AdvancementProgress advancementProgress = advancement.func_192747_a(manager.func_192778_a(location));
        }
    }

    @SubscribeEvent
    public static void onLivingEnterBiome(TickEvent.PlayerTickEvent event) {
        if (event.player.func_130014_f_() instanceof ServerWorld && event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            ServerWorld serverWorld = (ServerWorld)event.player.field_70170_p;
            ResourceLocation location = serverWorld.func_226691_t_(player.func_233580_cy_()).getRegistryName();
            if (serverWorld.func_226691_t_(player.func_233580_cy_()).getRegistryName() == GSKOBiomes.NAMELESS_HILL_KEY.getRegistryName()) {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
            }
            boolean precondition = player.field_70173_aa % 20 == 0 && location != null && !player.func_70644_a((Effect)EffectRegistry.HAKUREI_BLESS_EFFECT.get());
            LazyOptional cap = serverWorld.getCapability(GSKOCapabilities.BLOODY_MIST);
            cap.ifPresent(capability -> {
                List<String> biomes = capability.getBiomeRegistryNames();
                biomes.forEach(biomeRegistryName -> {
                    if (precondition && Objects.equals(location.toString(), biomeRegistryName) && capability.isTriggered()) {
                        player.func_146105_b((ITextComponent)GensokyoOntology.withTranslation("msg.", ".enter_danger_biome.scarlet_mansion_precincts"), true);
                        player.func_70097_a(DamageSource.field_76368_d, 1.0f);
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (!(event.getEntityLiving().func_130014_f_() instanceof ServerWorld)) {
            return;
        }
        GSKOEntityEvents.fairyDropDanmaku(event);
        GSKOEntityEvents.dropLunarDanmaku(event.getEntityLiving(), (ServerWorld)event.getEntityLiving().field_70170_p);
        if (event.getEntityLiving() instanceof PlayerEntity) {
            GSKOPowerCapability.INSTANCE.add(-1.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        PlayerInventory inventory = player.field_71071_by;
        if (player.func_233643_dh_()) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i).func_77973_b() != ItemRegistry.EXTEND_ITEM.get()) continue;
                player.func_70606_j(20.0f);
                world.func_72960_a((Entity)player, (byte)35);
                inventory.func_70301_a(i).func_190918_g(1);
            }
        }
        world.getCapability(GSKOCapabilities.IMPERISHABLE_NIGHT).ifPresent(cap -> cap.setTriggered(false));
    }

    @SubscribeEvent
    public static void playBGMToPlayer(TickEvent.PlayerTickEvent event) {
        if (event.player.func_184102_h() == null) {
            return;
        }
        ServerWorld serverWorld = event.player.func_184102_h().func_71218_a(GSKODimensions.GENSOKYO);
        if (event.player.func_130014_f_().func_234923_W_().equals(GSKODimensions.GENSOKYO) && event.player.field_70173_aa % GSKOMathUtil.randomRange(200, 1000) == 0) {
            event.player.func_184185_a((SoundEvent)GSKOSoundEvents.CICADA_AMBIENT.get(), 0.3f, 1.0f);
        }
    }

    public static void onHakureiBless(LivingEvent.LivingUpdateEvent event) {
        EffectInstance effect = event.getEntityLiving().func_70660_b((Effect)EffectRegistry.HAKUREI_BLESS_EFFECT.get());
        if (effect == null) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        LivingEntity living = event.getEntityLiving();
        if (effect.func_76459_b() > 0 && world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LazyOptional bloodyMist = serverWorld.getCapability(GSKOCapabilities.BLOODY_MIST);
            bloodyMist.ifPresent(capability -> capability.setTriggered(false));
        } else if (effect.func_76459_b() <= 0 && world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            LazyOptional bloodyMist = serverWorld.getCapability(GSKOCapabilities.BLOODY_MIST);
            bloodyMist.ifPresent(capability -> capability.setTriggered(true));
        }
    }

    private static void fairyDropDanmaku(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof FairyEntity) {
            FairyEntity fairy = (FairyEntity)event.getEntityLiving();
            Random random = new Random();
            if (event.getSource() == GSKODamageSource.DANMAKU) {
                if (random.nextInt(100) < 8) {
                    fairy.func_199701_a_(new ItemStack((IItemProvider)ItemRegistry.LIFE_FRAGMENT.get()));
                }
                for (int i = 0; i < random.nextInt(3); ++i) {
                    List<Item> danmakuItems = DanmakuUtil.getAllDanmakuItem();
                    fairy.func_199703_a((IItemProvider)danmakuItems.get(random.nextInt(danmakuItems.size())));
                }
            }
        }
    }

    private static void dropLunarDanmaku(LivingEntity living, ServerWorld serverWorld) {
        if (GSKOWorldUtil.isEntityInDimension((Entity)living, GSKODimensions.GENSOKYO)) {
            LazyOptional capability = serverWorld.getCapability(GSKOCapabilities.IMPERISHABLE_NIGHT);
            capability.ifPresent(cap -> {
                Random random = new Random();
                if (random.nextInt(100) < 23) {
                    living.func_199701_a_(new ItemStack((IItemProvider)ItemRegistry.FAKE_LUNAR_ITEM.get()));
                }
            });
        }
    }

    private static void performHypnosis(LivingEvent.LivingUpdateEvent event, HypnosisEffect effect) {
        VillagerEntity villager;
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_70644_a((Effect)effect)) {
                ServerWorld serverWorld = (ServerWorld)player.func_130014_f_();
                serverWorld.func_241114_a_(13000L);
                player.func_213301_b(Pose.SLEEPING);
                player.func_213342_e(player.func_233580_cy_());
            }
        } else if (event.getEntityLiving() instanceof VillagerEntity && (villager = (VillagerEntity)event.getEntityLiving()).func_70644_a((Effect)effect)) {
            ServerWorld serverWorld = (ServerWorld)villager.func_130014_f_();
            serverWorld.func_241114_a_(13000L);
            villager.func_213301_b(Pose.SLEEPING);
            villager.func_213342_e(villager.func_233580_cy_());
        }
    }

    private static void performLovePotion(LivingEvent.LivingUpdateEvent event, LovePotionEffect effect) {
    }
}

