/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.events;

import github.thelawf.gensokyoontology.common.item.touhou.SakuyaStopWatch;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gensokyoontology", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GSKOItemStackEvents {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Vector3d motion = new Vector3d(0.0, 0.0, 0.0);
    private static float speed = 0.0f;

    @SubscribeEvent
    public static void onSakuyaStopWatchTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            World world = player.field_70170_p;
            AxisAlignedBB aabb = new AxisAlignedBB(player.func_213303_ch().func_178786_a(10.0, 10.0, 10.0), player.func_213303_ch().func_72441_c(10.0, 10.0, 10.0));
            ItemStack stack = player.func_184614_ca();
            if (player.field_70173_aa < SakuyaStopWatch.totalTicks && stack.func_77978_p() != null) {
                GSKOItemStackEvents.freezeEntities(world, null, aabb, 15.0f);
            }
            if (player.field_70173_aa >= SakuyaStopWatch.totalTicks && stack.func_77973_b() == ItemRegistry.SAKUYA_WATCH.get()) {
                stack.func_77982_d(new CompoundNBT());
                GSKOItemStackEvents.unfreezeEntities(world, null, aabb, 15.0f);
            }
        }
    }

    public static void freezeEntities(World world, @Nullable Predicate<Entity> predicate, AxisAlignedBB aabb, float radius) {
        if (predicate == null) {
            world.func_217357_a(Entity.class, aabb).stream().filter(entity -> aabb.func_189972_c().func_72438_d(entity.func_213303_ch()) <= (double)radius && !(entity instanceof PlayerEntity)).forEach(GSKOItemStackEvents::forEntitiesOnTimeFreeze);
            return;
        }
        world.func_217357_a(LivingEntity.class, aabb).stream().filter(living -> aabb.func_189972_c().func_72438_d(living.func_213303_ch()) <= (double)radius && predicate.test((Entity)living)).forEach(GSKOItemStackEvents::forEntitiesOnTimeFreeze);
    }

    public static void unfreezeEntities(World world, @Nullable Predicate<Entity> predicate, AxisAlignedBB aabb, float radius) {
        if (predicate == null) {
            world.func_217357_a(Entity.class, aabb).stream().filter(entity -> aabb.func_189972_c().func_72438_d(entity.func_213303_ch()) <= (double)radius && !(entity instanceof PlayerEntity)).forEach(GSKOItemStackEvents::forEntitiesOnTimeUnfreeze);
            return;
        }
        world.func_217357_a(Entity.class, aabb).stream().filter(entity -> aabb.func_189972_c().func_72438_d(entity.func_213303_ch()) <= (double)radius && predicate.test((Entity)entity)).forEach(GSKOItemStackEvents::forEntitiesOnTimeUnfreeze);
    }

    private static void forEntitiesOnTimeFreeze(Entity entity) {
        if (entity instanceof ProjectileEntity) {
            entity.func_189654_d(true);
            motion = entity.func_213322_ci();
            entity.func_213293_j(0.0, 0.0, 0.0);
            entity.field_70133_I = true;
        } else if (entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
            LivingEntity living = (LivingEntity)entity;
            speed = living.func_70689_ay();
            living.func_70659_e(0.0f);
        }
        entity.canUpdate(false);
    }

    private static void forEntitiesOnTimeUnfreeze(Entity entity) {
        if (entity instanceof ProjectileEntity) {
            entity.func_213317_d(motion);
            entity.field_70133_I = true;
        } else if (entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
            LivingEntity living = (LivingEntity)entity;
            living.func_70659_e(speed);
        }
        entity.canUpdate(true);
    }
}

