/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.common.events;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import github.thelawf.gensokyoontology.common.entity.spawn.LilyWhiteSpawner;
import github.thelawf.gensokyoontology.common.world.GSKODimensions;
import github.thelawf.gensokyoontology.common.world.GSKOEntityGenerator;
import github.thelawf.gensokyoontology.common.world.dimension.biome.GSKOBiomes;
import github.thelawf.gensokyoontology.common.world.feature.GSKOFeatureGenerator;
import github.thelawf.gensokyoontology.core.init.BlockRegistry;
import github.thelawf.gensokyoontology.core.init.EntityRegistry;
import github.thelawf.gensokyoontology.core.init.ItemRegistry;
import github.thelawf.gensokyoontology.core.init.StructureRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="gensokyoontology")
public class GSKOWorldEvents {
    @SubscribeEvent
    public static void onLivingSpawn(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.THEEND) || event.getCategory().equals((Object)Biome.Category.NETHER)) {
            return;
        }
        List spawners = event.getSpawns().getSpawner(((EntityType)EntityRegistry.FAIRY_ENTITY.get()).func_220339_d());
        spawners.add(new MobSpawnInfo.Spawners((EntityType)EntityRegistry.FAIRY_ENTITY.get(), 38, 2, 4));
        GSKOEntityGenerator.addEntityToBiomes(event, (EntityType)EntityRegistry.SPECTRE_ENTITY.get(), 20, 3, 5, GSKOBiomes.HIGAN_KEY, GSKOBiomes.BAMBOO_FOREST_LOST_KEY, GSKOBiomes.SCARLET_MANSION_PRECINCTS_KEY);
    }

    @SubscribeEvent
    public static void onItemEntityTick(EntityEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().func_200600_R() == EntityType.field_200765_E) {
            ItemEntity itemEntity = (ItemEntity)event.getEntity();
            World world = event.getEntity().func_130014_f_();
            if (itemEntity.func_92059_d().func_77973_b() == ItemRegistry.SAKE_WORM.get() && itemEntity.field_70173_aa > 100 && world.func_180495_p(itemEntity.func_233580_cy_()).func_177230_c() == Blocks.field_150355_j) {
                world.func_175656_a(itemEntity.func_233580_cy_(), ((FlowingFluidBlock)BlockRegistry.SAKE_WINE_BLOCK.get()).func_176223_P());
            }
            GSKOWorldEvents.onGapEntityTick(itemEntity, (BlockItem)ItemRegistry.GAP_BLOCK.get());
        }
    }

    @SubscribeEvent
    public static void trySpawnBoss(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)event.player.field_70170_p;
            PlayerEntity player = event.player;
            LilyWhiteSpawner.spawn(serverWorld, player, player.func_233580_cy_(), player.field_70173_aa, 0.01f);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ServerWorld serverWorld;
        IChunk chunk = event.getChunk();
        if (chunk.getWorldForge() instanceof ServerWorld && (serverWorld = (ServerWorld)chunk.getWorldForge()).func_234923_W_().equals(GSKODimensions.GENSOKYO)) {
            Biome biome = serverWorld.func_226691_t_(chunk.func_76632_l().func_206849_h());
            String string = "gensokyoontology";
        }
    }

    @SubscribeEvent
    public static void addDimensionSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            Method GET_CODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            try {
                ResourceLocation location = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GET_CODEC_METHOD.invoke((Object)serverWorld.func_72863_F().func_201711_g(), new Object[0])));
                if (location != null && location.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LogManager.getLogger().error("Was unable to check if " + serverWorld.func_234923_W_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().field_186029_c instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(StructureRegistry.ALICE_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.ALICE_HOUSE.get()));
            tempMap.putIfAbsent(StructureRegistry.SCARLET_DEVIL_MANSION.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.SCARLET_DEVIL_MANSION.get()));
            tempMap.putIfAbsent(StructureRegistry.MYSTIA_IZAKAYA.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.MYSTIA_IZAKAYA.get()));
            tempMap.putIfAbsent(StructureRegistry.HAKUREI_SHRINE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.HAKUREI_SHRINE.get()));
            tempMap.putIfAbsent(StructureRegistry.CIRNO_ICE_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.CIRNO_ICE_HOUSE.get()));
            tempMap.putIfAbsent(StructureRegistry.CHIREIDEN.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.CHIREIDEN.get()));
            tempMap.putIfAbsent(StructureRegistry.BEAST_PATHWAY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.BEAST_PATHWAY.get()));
            tempMap.putIfAbsent(StructureRegistry.HUMAN_VILLAGE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureRegistry.HUMAN_VILLAGE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        GSKOFeatureGenerator.generateOverworldOre(event);
        GSKOFeatureGenerator.generateGensokyoOre(event);
    }

    private static void onGapEntityTick(ItemEntity entity, BlockItem gapItem) {
        if (entity.func_92059_d().func_77973_b() == gapItem) {
            World world = entity.func_130014_f_();
            Predicate<BlockPos> predicate = pos -> {
                BlockPos.Mutable mutable = pos.func_239590_i_();
                return world.func_180495_p((BlockPos)mutable).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177978_c()).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177968_d()).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177974_f()).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177976_e()).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177982_a(1, 0, 1)).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177982_a(1, 0, -1)).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177982_a(-1, 0, 1)).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(mutable.func_177982_a(-1, 0, -1)).func_177230_c() == Blocks.field_150355_j;
            };
        }
    }

    private static void spawnEntityIn(ServerWorld serverWorld, EntityClassification classification, WorldEvent.PotentialSpawns event) {
        List<ResourceLocation> biomeIds = Arrays.asList(new ResourceLocation("minecraft:plains"), new ResourceLocation("minecraft:desert"), new ResourceLocation("minecraft:forest"), new ResourceLocation("miencraft:taiga"), new ResourceLocation("minecraft:mountains"), new ResourceLocation("minecraft:snowy_tundra"), new ResourceLocation("minecraft:snowy_mountains"), new ResourceLocation("minecraft:jungle"), new ResourceLocation("minecraft:birch_forest"), new ResourceLocation("minecraft:savanna"), new ResourceLocation("minecraft:savanna_plateau"), new ResourceLocation("minecraft:dark_forest"), new ResourceLocation("minecraft:bamboo_jungle"), new ResourceLocation("minecraft:giant_spruce_taiga"));
        serverWorld.func_72863_F().func_201711_g().func_202090_b().func_235203_c_().forEach(biome -> GSKOWorldEvents.spawnEntityIn(biome, biomeIds, classification));
    }

    private static void spawnEntityIn(Biome biome, List<ResourceLocation> biomeIds, EntityClassification classification) {
        ImmutableList entityTypes = ImmutableList.of((Object)EntityRegistry.FAIRY_ENTITY.get());
        biomeIds.forEach(resourceLocation -> {
            if (biome.getRegistryName() != null && biome.getRegistryName().equals(resourceLocation)) {
                int weight = 8;
                int minCount = 3;
                int n = 8;
            }
        });
    }
}

